
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("vitamin_optimization")

# Create variables
vitamin_b7 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b7")
vitamin_b12 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b12")
zinc = m.addVar(lb=0, vtype=GRB.INTEGER, name="zinc")
vitamin_b2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="vitamin_b2")

# Set objective function
obj = 7.67 * vitamin_b7**2 + 1.72 * vitamin_b7 * vitamin_b12 + 8.57 * vitamin_b7 * vitamin_b2 + 8.81 * vitamin_b12**2 + 2.9 * vitamin_b12 * zinc + 7.6 * zinc**2 + 1.36 * zinc * vitamin_b2 + 5.69 * vitamin_b7 + 5.34 * zinc
m.setObjective(obj, GRB.MAXIMIZE)

# Add constraints
m.addConstr(11 * vitamin_b12 + 13 * zinc >= 14, "c1")
m.addConstr(11 * vitamin_b12 + 12 * vitamin_b2 >= 10, "c2")
m.addConstr(10 * vitamin_b7**2 + 13 * zinc**2 >= 8, "c3")
m.addConstr(13 * zinc + 12 * vitamin_b2 >= 8, "c4")
m.addConstr(10 * vitamin_b7 + 11 * vitamin_b12 >= 12, "c5")
m.addConstr(9 * vitamin_b7 + 5 * vitamin_b12 + 10 * zinc >= 67, "c6")
m.addConstr(9 * vitamin_b7 + 5 * vitamin_b12 + 11 * vitamin_b2 >= 67, "c7")
m.addConstr(9 * vitamin_b7**2 + 5 * vitamin_b12**2 + 10 * zinc**2 >= 49, "c8")
m.addConstr(9 * vitamin_b7 + 5 * vitamin_b12 + 11 * vitamin_b2 >= 49, "c9")
m.addConstr(10 * vitamin_b7 + 11 * vitamin_b12 <= 48, "c10")
m.addConstr(10 * vitamin_b7**2 + 13 * zinc**2 <= 31, "c11")
m.addConstr(10 * vitamin_b7 + 12 * vitamin_b2 <= 60, "c12")
m.addConstr(11 * vitamin_b12 + 13 * zinc <= 42, "c13")
m.addConstr(10 * vitamin_b7 + 11 * vitamin_b12 + 13 * zinc + 12 * vitamin_b2 <= 42, "c14")
m.addConstr(9 * vitamin_b7**2 + 11 * vitamin_b2**2 <= 194, "c15")
m.addConstr(9 * vitamin_b7 + 5 * vitamin_b12 <= 228, "c16")
m.addConstr(9 * vitamin_b7**2 + 10 * zinc**2 <= 195, "c17")
m.addConstr(5 * vitamin_b12**2 + 10 * zinc**2 + 11 * vitamin_b2**2 <= 194, "c18")
m.addConstr(9 * vitamin_b7 + 5 * vitamin_b12 + 11 * vitamin_b2 <= 141, "c19")
m.addConstr(9 * vitamin_b7 + 5 * vitamin_b12 + 10 * zinc + 11 * vitamin_b2 <= 141, "c20")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

