
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0")  # milligrams of vitamin B7
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # milligrams of vitamin B12
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x2")  # milligrams of zinc
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x3")  # milligrams of vitamin B2

    # Objective function
    model.setObjective(7.67 * x0**2 + 1.72 * x0 * x1 + 8.57 * x0 * x3 + 8.81 * x1**2 + 2.9 * x1 * x2 + 7.6 * x2**2 + 1.36 * x2 * x3 + 5.69 * x0 + 5.34 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(10 * x0 + 11 * x1 + 13 * x2 + 12 * x3 <= 83)
    model.addConstr(9 * x0 + 5 * x1 + 10 * x2 + 11 * x3 <= 312)
    model.addConstr(11 * x1 + 13 * x2 >= 14)
    model.addConstr(11 * x1 + 12 * x3 >= 10)
    model.addConstr(10 * x0**2 + 13 * x2**2 >= 8)
    model.addConstr(13 * x2 + 12 * x3 >= 8)
    model.addConstr(10 * x0 + 11 * x1 >= 12)
    model.addConstr(9 * x0 + 5 * x1 + 10 * x2 >= 67)
    model.addConstr(9 * x0 + 5 * x1 + 11 * x3 >= 67)
    model.addConstr(9 * x0**2 + 5 * x1**2 + 10 * x2**2 >= 49)
    model.addConstr(9 * x0 + 5 * x1 + 11 * x3 >= 49)
    model.addConstr(10 * x0 + 11 * x1 <= 48)
    model.addConstr(10 * x0**2 + 13 * x2**2 <= 31)
    model.addConstr(10 * x0 + 12 * x3 <= 60)
    model.addConstr(11 * x1 + 13 * x2 <= 42)
    model.addConstr(10 * x0 + 11 * x1 + 13 * x2 + 12 * x3 <= 42)
    model.addConstr(9 * x0**2 + 11 * x2**2 <= 194)
    model.addConstr(9 * x0 + 5 * x1 <= 228)
    model.addConstr(9 * x0**2 + 10 * x2**2 <= 195)
    model.addConstr(5 * x1**2 + 10 * x2**2 + 11 * x3**2 <= 194)
    model.addConstr(9 * x0 + 5 * x1 + 11 * x3 <= 141)
    model.addConstr(9 * x0 + 5 * x1 + 10 * x2 + 11 * x3 <= 141)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x0: {x0.varValue}")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
