
from gurobipy import Model, GRB

# Create a new model
m = Model("Resource Allocation")

# Create variables
medical_platoons = m.addVar(vtype=GRB.INTEGER, name="x0")
signal_platoons = m.addVar(vtype=GRB.INTEGER, name="x1")
water_purification_units = m.addVar(vtype=GRB.INTEGER, name="x2")
mechanized_infantry_companies = m.addVar(vtype=GRB.INTEGER, name="x3")
armored_companies = m.addVar(vtype=GRB.INTEGER, name="x4")

# Set objective function
m.setObjective(6 * medical_platoons + 2 * signal_platoons + 9 * water_purification_units + 1 * mechanized_infantry_companies + 1 * armored_companies, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * medical_platoons + 5 * signal_platoons + 1 * water_purification_units + 2 * mechanized_infantry_companies + 3 * armored_companies <= 92, "Logistical Capacity")
m.addConstr(5 * medical_platoons + 5 * signal_platoons >= 6, "Constraint 1")
m.addConstr(5 * medical_platoons + 2 * mechanized_infantry_companies >= 18, "Constraint 2")
m.addConstr(2 * mechanized_infantry_companies + 3 * armored_companies >= 17, "Constraint 3")
m.addConstr(5 * medical_platoons + 5 * signal_platoons + 2 * mechanized_infantry_companies >= 9, "Constraint 4")
m.addConstr(5 * signal_platoons + 2 * mechanized_infantry_companies + 3 * armored_companies >= 9, "Constraint 5")
m.addConstr(5 * medical_platoons + 5 * signal_platoons + 2 * mechanized_infantry_companies >= 14, "Constraint 6")
m.addConstr(5 * signal_platoons + 2 * mechanized_infantry_companies + 3 * armored_companies >= 14, "Constraint 7")
m.addConstr(-10 * signal_platoons + 7 * armored_companies >= 0, "Constraint 8")
m.addConstr(5 * signal_platoons + 3 * armored_companies <= 64, "Constraint 9")
m.addConstr(5 * signal_platoons + 2 * mechanized_infantry_companies <= 46, "Constraint 10")
m.addConstr(5 * signal_platoons + 1 * water_purification_units + 3 * armored_companies <= 30, "Constraint 11")
m.addConstr(1 * water_purification_units + 2 * mechanized_infantry_companies + 3 * armored_companies <= 58, "Constraint 12")
m.addConstr(5 * medical_platoons + 2 * mechanized_infantry_companies + 3 * armored_companies <= 41, "Constraint 13")
m.addConstr(5 * medical_platoons + 1 * water_purification_units + 2 * mechanized_infantry_companies <= 45, "Constraint 14")
m.addConstr(5 * medical_platoons + 5 * signal_platoons + 1 * water_purification_units + 2 * mechanized_infantry_companies + 3 * armored_companies <= 45, "Constraint 15")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

