
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
medical_platoons = m.addVar(name="medical_platoons", vtype=gp.GRB.INTEGER)
signal_platoons = m.addVar(name="signal_platoons", vtype=gp.GRB.INTEGER)
water_purification_units = m.addVar(name="water_purification_units", vtype=gp.GRB.INTEGER)
mechanized_infantry_companies = m.addVar(name="mechanized_infantry_companies", vtype=gp.GRB.INTEGER)
armored_companies = m.addVar(name="armored_companies", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(6 * medical_platoons + 2 * signal_platoons + 9 * water_purification_units + 
               mechanized_infantry_companies + armored_companies, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(5 * medical_platoons + 5 * signal_platoons >= 6)
m.addConstr(5 * medical_platoons + 2 * mechanized_infantry_companies >= 18)
m.addConstr(2 * mechanized_infantry_companies + 3 * armored_companies >= 17)
m.addConstr(5 * medical_platoons + 5 * signal_platoons + 2 * mechanized_infantry_companies >= 9)
m.addConstr(5 * signal_platoons + 2 * mechanized_infantry_companies + 3 * armored_companies >= 9)
m.addConstr(5 * medical_platoons + 5 * signal_platoons + 2 * mechanized_infantry_companies >= 14)
m.addConstr(5 * signal_platoons + 2 * mechanized_infantry_companies + 3 * armored_companies >= 14)
m.addConstr(-10 * signal_platoons + 7 * armored_companies >= 0)
m.addConstr(5 * signal_platoons + 3 * armored_companies <= 64)
m.addConstr(5 * signal_platoons + 2 * mechanized_infantry_companies <= 46)
m.addConstr(5 * signal_platoons + water_purification_units + 3 * armored_companies <= 30)
m.addConstr(water_purification_units + 2 * mechanized_infantry_companies + 3 * armored_companies <= 58)
m.addConstr(5 * medical_platoons + 2 * mechanized_infantry_companies + 3 * armored_companies <= 41)
m.addConstr(5 * medical_platoons + water_purification_units + 2 * mechanized_infantry_companies <= 45)
m.addConstr(5 * medical_platoons + 5 * signal_platoons + water_purification_units + 
             2 * mechanized_infantry_companies + 3 * armored_companies <= 45)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Medical Platoons: ", medical_platoons.varValue)
    print("Signal Platoons: ", signal_platoons.varValue)
    print("Water Purification Units: ", water_purification_units.varValue)
    print("Mechanized Infantry Companies: ", mechanized_infantry_companies.varValue)
    print("Armored Companies: ", armored_companies.varValue)
else:
    print("The model is infeasible.")
