
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
bananas = m.addVar(name="bananas", lb=0)
chicken_thighs = m.addVar(name="chicken_thighs", lb=0)
strips_of_bacon = m.addVar(name="strips_of_bacon", lb=0)

# Objective function
m.setObjective(6.76 * bananas + 8.33 * chicken_thighs + 5.66 * strips_of_bacon, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(11.46 * bananas + 6.36 * chicken_thighs + 4.63 * strips_of_bacon <= 135)  # r0
m.addConstr(11.46 * bananas + 6.36 * chicken_thighs >= 17)  
m.addConstr(6.36 * chicken_thighs + 4.63 * strips_of_bacon >= 30)  
m.addConstr(11.46 * bananas + 6.36 * chicken_thighs + 4.63 * strips_of_bacon >= 23)  
m.addConstr(6.51 * bananas + 10.01 * chicken_thighs >= 52)  # tastiness rating from bananas and chicken thighs
m.addConstr(10.01 * chicken_thighs + 7.3 * strips_of_bacon >= 27)  # tastiness rating from chicken thighs and strips of bacon
m.addConstr(6.51 * bananas + 7.3 * strips_of_bacon >= 51)  # tastiness rating from bananas and strips of bacon
m.addConstr(6.51 * bananas + 10.01 * chicken_thighs + 7.3 * strips_of_bacon >= 51)  # total tastiness rating
m.addConstr(11.08 * bananas + 10.99 * strips_of_bacon >= 10)  # sourness index from bananas and strips of bacon
m.addConstr(11.08 * bananas + 5.82 * chicken_thighs + 10.99 * strips_of_bacon >= 10)  # total sourness index
m.addConstr(8 * bananas - 6 * strips_of_bacon >= 0)  
m.addConstr(-bananas + 3 * chicken_thighs >= 0)  
m.addConstr(11.46 * bananas + 4.63 * strips_of_bacon <= 119)  
m.addConstr(6.36 * chicken_thighs + 4.63 * strips_of_bacon <= 123)  
m.addConstr(6.51 * bananas + 7.3 * strips_of_bacon <= 168)  
m.addConstr(10.01 * chicken_thighs + 7.3 * strips_of_bacon <= 107)  
m.addConstr(6.51 * bananas + 10.01 * chicken_thighs <= 171)  
m.addConstr(11.08 * bananas + 10.99 * strips_of_bacon <= 16)  

# Solve the problem
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bananas: {bananas.varValue}")
    print(f"Chicken Thighs: {chicken_thighs.varValue}")
    print(f"Strips of Bacon: {strips_of_bacon.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
