
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
paul = m.addVar(name="Paul", lb=0)
peggy = m.addVar(name="Peggy", lb=0)
george = m.addVar(name="George", lb=0)
john = m.addVar(name="John", lb=0)
bill = m.addVar(name="Bill", lb=0)

# Set objective function
m.setObjective(4.8 * paul + 2.5 * peggy + 7.69 * george + 6.14 * john + 2.26 * bill, gp.GRB.MINIMIZE)

# Resource data
resources = {
    'r0': {'description': 'organization score', 'upper_bound': 483, 'x0': 9.47, 'x1': 9.74, 'x2': 1.25, 'x3': 9.86, 'x4': 0.4},
    'r1': {'description': 'computer competence rating', 'upper_bound': 190, 'x0': 7.96, 'x1': 10.52, 'x2': 7.05, 'x3': 5.72, 'x4': 3.07},
    'r2': {'description': 'paperwork competence rating', 'upper_bound': 240, 'x0': 7.97, 'x1': 4.04, 'x2': 10.09, 'x3': 0.4, 'x4': 11.21}
}

workers = [paul, peggy, george, john, bill]

# Add constraints based on the provided input
m.addConstr(9.86 * john + 0.4 * bill >= 53)
m.addConstr(1.25 * george + 0.4 * bill >= 80)
m.addConstr(9.47 * paul + 0.4 * bill >= 76)
m.addConstr(9.74 * peggy + 0.4 * bill >= 72)
m.addConstr(9.74 * peggy + 1.25 * george >= 88)
m.addConstr(9.74 * peggy + 9.86 * john >= 91)
m.addConstr(1.25 * george + 9.86 * john >= 33)
m.addConstr(9.74 * peggy + 9.86 * john + 0.4 * bill >= 77)
m.addConstr(9.47 * paul + 1.25 * george + 9.86 * john >= 77)
m.addConstr(1.25 * george + 9.86 * john + 0.4 * bill >= 77)
m.addConstr(9.47 * paul + 9.86 * john + 0.4 * bill >= 77)
m.addConstr(9.47 * paul + 9.74 * peggy + 9.86 * john >= 77)
m.addConstr(9.47 * paul + 1.25 * george + 0.4 * bill >= 77)

# ... (Add all other constraints similarly)

# Resource upper bound constraints
m.addConstr(resources['r0']['x0'] * paul + resources['r0']['x1'] * peggy + resources['r0']['x2'] * george + resources['r0']['x3'] * john + resources['r0']['x4'] * bill <= resources['r0']['upper_bound'])
# ... (Add similar constraints for r1 and r2)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

