
import gurobi as gp

# Define variables
hours_worked_by_Paul = gp.Var(name="hours_worked_by_Paul", lb=0)
hours_worked_by_Peggy = gp.Var(name="hours_worked_by_Peggy", lb=0)
hours_worked_by_George = gp.Var(name="hours_worked_by_George", lb=0)
hours_worked_by_John = gp.Var(name="hours_worked_by_John", lb=0)
hours_worked_by_Bill = gp.Var(name="hours_worked_by_Bill", lb=0)

# Define model
m = gp.Model()

# Objective function
m.setObjective(4.8 * hours_worked_by_Paul + 2.5 * hours_worked_by_Peggy + 
               7.69 * hours_worked_by_George + 6.14 * hours_worked_by_John + 
               2.26 * hours_worked_by_Bill, gp.GRB.MINIMIZE)

# Constraints
# Organization score constraints
m.addConstr(9.47 * hours_worked_by_Paul <= 483)
m.addConstr(9.74 * hours_worked_by_Peggy <= 483)
m.addConstr(1.25 * hours_worked_by_George <= 483)
m.addConstr(9.86 * hours_worked_by_John <= 483)
m.addConstr(0.4 * hours_worked_by_Bill <= 483)

m.addConstr(9.47 * hours_worked_by_Paul + 9.86 * hours_worked_by_John + 0.4 * hours_worked_by_Bill >= 53)
m.addConstr(1.25 * hours_worked_by_George + 0.4 * hours_worked_by_Bill >= 80)
m.addConstr(9.47 * hours_worked_by_Paul + 0.4 * hours_worked_by_Bill >= 76)
m.addConstr(9.74 * hours_worked_by_Peggy + 0.4 * hours_worked_by_Bill >= 72)
m.addConstr(9.74 * hours_worked_by_Peggy + 1.25 * hours_worked_by_George >= 88)
m.addConstr(9.74 * hours_worked_by_Peggy + 9.86 * hours_worked_by_John >= 91)
m.addConstr(1.25 * hours_worked_by_George + 9.86 * hours_worked_by_John >= 33)
m.addConstr(9.74 * hours_worked_by_Peggy + 9.86 * hours_worked_by_John + 0.4 * hours_worked_by_Bill >= 77)

# Computer competence rating constraints
m.addConstr(7.96 * hours_worked_by_Paul + 5.72 * hours_worked_by_John + 3.07 * hours_worked_by_Bill >= 29)
m.addConstr(7.96 * hours_worked_by_Paul + 3.07 * hours_worked_by_Bill >= 26)
m.addConstr(7.05 * hours_worked_by_George + 3.07 * hours_worked_by_Bill >= 22)
m.addConstr(7.96 * hours_worked_by_Paul + 5.72 * hours_worked_by_John >= 28)

# Paperwork competence rating constraints
m.addConstr(7.97 * hours_worked_by_Paul + 0.4 * hours_worked_by_John >= 43)
m.addConstr(0.4 * hours_worked_by_John + 11.21 * hours_worked_by_Bill >= 17)
m.addConstr(4.04 * hours_worked_by_Peggy + 0.4 * hours_worked_by_John >= 20)

# Other constraints
m.addConstr(hours_worked_by_Peggy - 4 * hours_worked_by_John >= 0)
m.addConstr(-9 * hours_worked_by_Paul + 4 * hours_worked_by_John >= 0)

# Upper bounds
m.addConstr(9.47 * hours_worked_by_George + 0.4 * hours_worked_by_Bill <= 297)
m.addConstr(9.74 * hours_worked_by_Peggy + 0.4 * hours_worked_by_Bill <= 405)
m.addConstr(9.47 * hours_worked_by_Paul + 9.74 * hours_worked_by_Peggy + 0.4 * hours_worked_by_Bill <= 285)

# Solve model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Paul: ", hours_worked_by_Paul.varValue)
    print("Hours worked by Peggy: ", hours_worked_by_Peggy.varValue)
    print("Hours worked by George: ", hours_worked_by_George.varValue)
    print("Hours worked by John: ", hours_worked_by_John.varValue)
    print("Hours worked by Bill: ", hours_worked_by_Bill.varValue)
else:
    print("No optimal solution found")
