
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cereal = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bowls_of_cereal")
ramen = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bowls_of_instant_ramen")
tomatoes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="tomatoes")

# Set objective function
m.setObjective(3 * cereal + 3 * ramen + 7 * tomatoes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11 * cereal + 13 * ramen >= 108, "c1")
m.addConstr(11 * cereal + 24 * tomatoes >= 90, "c2")
m.addConstr(11 * cereal + 13 * ramen + 24 * tomatoes >= 90, "c3")
m.addConstr(18 * cereal + 5 * ramen >= 42, "c4")
m.addConstr(18 * cereal + 8 * tomatoes >= 67, "c5")
m.addConstr(5 * ramen + 8 * tomatoes >= 106, "c6")
m.addConstr(18 * cereal + 5 * ramen + 8 * tomatoes >= 63, "c7")
m.addConstr(-2 * cereal + 6 * tomatoes >= 0, "c8")
m.addConstr(9 * cereal - 2 * ramen >= 0, "c9")

# Resource Constraints
m.addConstr(11 * cereal + 13 * ramen <= 319, "c10")
m.addConstr(11 * cereal + 24 * tomatoes <= 303, "c11")
m.addConstr(11 * cereal + 13 * ramen + 24 * tomatoes <= 448, "umami_limit")
m.addConstr(18 * cereal + 5 * ramen + 8 * tomatoes <= 331, "protein_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('bowls_of_cereal:', cereal.x)
    print('bowls_of_instant_ramen:', ramen.x)
    print('tomatoes:', tomatoes.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

