
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
fat = m.addVar(vtype=gp.GRB.INTEGER, name="fat")
vitamin_c = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_c")
iron = m.addVar(vtype=gp.GRB.CONTINUOUS, name="iron")
vitamin_b3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")

# Set objective function
m.setObjective(4 * fat + 5 * vitamin_c + 5 * iron + 2 * vitamin_b3, gp.GRB.MINIMIZE)

# Add constraints based on resource attributes
resource_data = {
    'r0': {'upper_bound': 97, 'x0': 7, 'x1': 6, 'x2': 6, 'x3': 5},
    'r1': {'upper_bound': 103, 'x0': 1, 'x1': 3, 'x2': 8, 'x3': 10},
    'r2': {'upper_bound': 94, 'x0': 8, 'x1': 6, 'x2': 9, 'x3': 3},
    'r3': {'upper_bound': 108, 'x0': 6, 'x1': 3, 'x2': 6, 'x3': 3},
    'r4': {'upper_bound': 77, 'x0': 9, 'x1': 7, 'x2': 2, 'x3': 7}
}

for resource, data in resource_data.items():
    m.addConstr(data['x0'] * fat + data['x1'] * vitamin_c + data['x2'] * iron + data['x3'] * vitamin_b3 <= data['upper_bound'], name=resource)


# Add additional constraints from the problem description
m.addConstr(6 * vitamin_c + 6 * iron >= 15)
m.addConstr(7 * fat + 6 * vitamin_c >= 8)
m.addConstr(6 * vitamin_c + 5 * vitamin_b3 >= 8)
m.addConstr(7 * fat + 5 * vitamin_b3 >= 8)
m.addConstr(6 * vitamin_c + 6 * iron + 5 * vitamin_b3 >= 18)
m.addConstr(7 * fat + 6 * vitamin_c + 6 * iron + 5 * vitamin_b3 >= 18)
m.addConstr(3 * vitamin_c + 8 * iron >= 11)
m.addConstr(8 * iron + 10 * vitamin_b3 >= 19)
m.addConstr(1 * fat + 3 * vitamin_c >= 15)
m.addConstr(3 * vitamin_c + 8 * iron + 10 * vitamin_b3 >= 25)
m.addConstr(1 * fat + 3 * vitamin_c + 8 * iron + 10 * vitamin_b3 >= 25)
m.addConstr(6 * vitamin_c + 3 * vitamin_b3 >= 23)
m.addConstr(8 * fat + 6 * vitamin_c >= 19)
m.addConstr(6 * vitamin_c + 9 * iron >= 23)
m.addConstr(8 * fat + 9 * iron + 3 * vitamin_b3 >= 22)
m.addConstr(8 * fat + 6 * vitamin_c + 9 * iron + 3 * vitamin_b3 >= 22)
m.addConstr(6 * fat + 3 * vitamin_b3 >= 21)
m.addConstr(3 * vitamin_c + 3 * vitamin_b3 >= 16)
m.addConstr(6 * fat + 3 * vitamin_c + 6 * iron + 3 * vitamin_b3 >= 16)
m.addConstr(9 * fat + 7 * vitamin_c >= 16)
m.addConstr(9 * fat + 7 * vitamin_c + 2 * iron + 7 * vitamin_b3 >= 16)
m.addConstr(10 * vitamin_c - 7 * iron >= 0)
m.addConstr(-9 * fat + 7 * vitamin_c >= 0)
m.addConstr(6 * iron + 5 * vitamin_b3 <= 25)
m.addConstr(8 * iron + 10 * vitamin_b3 <= 88)
m.addConstr(1 * fat + 10 * vitamin_b3 <= 84)
m.addConstr(9 * iron + 3 * vitamin_b3 <= 77)
m.addConstr(8 * fat + 3 * vitamin_b3 <= 46)
m.addConstr(9 * fat + 7 * vitamin_b3 <= 20)
m.addConstr(2 * iron + 7 * vitamin_b3 <= 35)
m.addConstr(7 * vitamin_c + 2 * iron <= 23)
m.addConstr(7 * vitamin_c + 7 * vitamin_b3 <= 50)
m.addConstr(9 * fat + 7 * vitamin_c + 2 * iron <= 76)
m.addConstr(9 * fat + 2 * iron + 7 * vitamin_b3 <= 50)
m.addConstr(7 * vitamin_c + 2 * iron + 7 * vitamin_b3 <= 60)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

