
from gurobipy import *

# Create a new model
m = Model("Immune_Support")

# Define variables
vitamin_c = m.addVar(lb=0, name="Vitamin_C")
fiber = m.addVar(lb=0, name="Fiber")
vitamin_b3 = m.addVar(lb=0, name="Vitamin_B3")
vitamin_b7 = m.addVar(lb=0, name="Vitamin_B7")
vitamin_d = m.addVar(lb=0, name="Vitamin_D")
fat = m.addVar(lb=0, name="Fat")

# Define constraints
m.addConstr(vitamin_c + vitamin_b3 >= 14)
m.addConstr(vitamin_c + vitamin_b3 >= 19)

m.addConstr(fiber + vitamin_d + fat >= 14)
m.addConstr(fiber + vitamin_d + fat >= 19)
m.addConstr(fiber + vitamin_d + fat <= 86)

m.addConstr(6 * fiber**2 - 8 * vitamin_d**2 >= 0)

m.addConstr(vitamin_c + vitamin_b3 <= 90)
m.addConstr(vitamin_d**2 + fat**2 <= 83)
m.addConstr(vitamin_b7**2 + vitamin_d**2 <= 80)
m.addConstr(vitamin_c + vitamin_b7 <= 41)

m.addConstr(fiber + fat <= 55)
m.addConstr(vitamin_b3 + vitamin_d <= 70)
m.addConstr(fiber**2 + vitamin_b7**2 <= 88)
m.addConstr(vitamin_b3 + vitamin_b7 <= 100)

m.addConstr(fiber + vitamin_b3 <= 112)
m.addConstr(fiber**2 + vitamin_b7**2 + fat**2 <= 75)
m.addConstr(vitamin_c + vitamin_b3 + vitamin_d <= 91)
m.addConstr(fiber + vitamin_b7 + vitamin_d <= 31)
m.addConstr(fiber + vitamin_b3 + vitamin_b7 <= 31)

m.addConstr(vitamin_c + fiber + fat <= 81)
m.addConstr(vitamin_c + vitamin_b3 + fat <= 120)
m.addConstr(vitamin_c**2 + fiber**2 + vitamin_b7**2 <= 34)
m.addConstr(vitamin_b3**2 + vitamin_d**2 + fat**2 <= 100)

m.addConstr(vitamin_c + vitamin_b7 + vitamin_d <= 25)
m.addConstr(vitamin_c + fiber + vitamin_d <= 48)

# Objective function
m.setObjective(0, GRB.MAXIMIZE)

# Solve the model
m.optimize()

print("Vitamin C:", vitamin_c.x)
print("Fiber:", fiber.x)
print("Vitamin B3:", vitamin_b3.x)
print("Vitamin B7:", vitamin_b7.x)
print("Vitamin D:", vitamin_d.x)
print("Fat:", fat.x)

