
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
b6 = m.addVar(lb=0, name="B6")
ca = m.addVar(lb=0, name="Ca")
fe = m.addVar(lb=0, name="Fe")

# Set objective function
m.setObjective(2*b6**2 + 9*b6*ca + 7*b6*fe + 8*ca**2 + 9*ca*fe + 5*b6 + 9*ca + 3*fe, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4.33*b6 + 0.89*fe >= 24, "digestive_1")
m.addConstr(5.47*ca + 0.89*fe >= 37, "digestive_2")
m.addConstr(4.33*b6**2 + 5.47*ca**2 + 0.89*fe**2 >= 34, "digestive_3")
m.addConstr(3.53*ca + 1.44*fe >= 25, "kidney_1")
m.addConstr(5.28*b6 + 1.44*fe >= 36, "kidney_2")
m.addConstr(2.24*ca + 1.4*fe >= 20, "cognitive_1")
m.addConstr(0.38*b6 + 1.4*fe >= 31, "cognitive_2")
m.addConstr(0.38*b6**2 + 2.24*ca**2 >= 14, "cognitive_3")
m.addConstr(0.38*b6 + 2.24*ca + 1.4*fe >= 40, "cognitive_4")
m.addConstr(-10*b6 + 4*fe >= 0, "constraint_1")
m.addConstr(5.47*ca + 0.89*fe <= 94, "digestive_4")
m.addConstr(4.33*b6 + 5.47*ca <= 120, "digestive_5")
m.addConstr(4.33*b6 + 5.47*ca + 0.89*fe <= 120, "digestive_6")
m.addConstr(5.28*b6**2 + 1.44*fe**2 <= 97, "kidney_3")
m.addConstr(5.28*b6 + 3.53*ca <= 63, "kidney_4")
m.addConstr(5.28*b6 + 3.53*ca + 1.44*fe <= 63, "kidney_5")
m.addConstr(0.38*b6 + 1.4*fe <= 102, "cognitive_5")
m.addConstr(0.38*b6 + 2.24*ca + 1.4*fe <= 102, "cognitive_6")


# Resource Constraints based on the provided dictionary
resource_data = {'r0': {'description': 'digestive support index', 'upper_bound': 120, 'x0': 4.33, 'x1': 5.47, 'x2': 0.89}, 'r1': {'description': 'kidney support index', 'upper_bound': 129, 'x0': 5.28, 'x1': 3.53, 'x2': 1.44}, 'r2': {'description': 'cognitive performance index', 'upper_bound': 126, 'x0': 0.38, 'x1': 2.24, 'x2': 1.4}}

# These constraints are already added individually above, so this section is redundant.
# for resource, data in resource_data.items():
#     m.addConstr(data['x0']*b6 + data['x1']*ca + data['x2']*fe <= data['upper_bound'], resource)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('B6:', b6.x)
    print('Ca:', ca.x)
    print('Fe:', fe.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

