
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="milligrams of vitamin B6", lb=-gp.GRB.INFINITY)
x1 = m.addVar(name="milligrams of calcium", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="milligrams of iron", lb=-gp.GRB.INFINITY)

# Define the objective function
m.setObjective(2*x0**2 + 9*x0*x1 + 7*x0*x2 + 8*x1**2 + 9*x1*x2 + 5*x0 + 9*x1 + 3*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4.33*x0 <= 120)
m.addConstr(5.28*x0 <= 129)
m.addConstr(0.38*x0 <= 126)
m.addConstr(5.47*x1 <= 120)
m.addConstr(3.53*x1 <= 129)
m.addConstr(2.24*x1 <= 126)
m.addConstr(0.89*x2 <= 120)
m.addConstr(1.44*x2 <= 129)
m.addConstr(1.4*x2 <= 126)
m.addConstr(4.33*x0 + 0.89*x2 >= 24)
m.addConstr(5.47*x1 + 0.89*x2 >= 37)
m.addConstr((4.33)**2*x0**2 + (5.47)**2*x1**2 + (0.89)**2*x2**2 >= 34)
m.addConstr(3.53*x1 + 1.44*x2 >= 25)
m.addConstr(5.28*x0 + 1.44*x2 >= 36)
m.addConstr(2.24*x1 + 1.4*x2 >= 20)
m.addConstr(0.38*x0 + 1.4*x2 >= 31)
m.addConstr((0.38)**2*x0**2 + (2.24)**2*x1**2 >= 14)
m.addConstr(0.38*x0 + 2.24*x1 + 1.4*x2 >= 40)
m.addConstr(-10*x0 + 4*x2 >= 0)
m.addConstr(5.47*x1 + 0.89*x2 <= 94)
m.addConstr(4.33*x0 + 5.47*x1 <= 120)
m.addConstr(4.33*x0 + 5.47*x1 + 0.89*x2 <= 120)
m.addConstr((5.28)**2*x0**2 + (1.44)**2*x2**2 <= 97)
m.addConstr(5.28*x0 + 3.53*x1 <= 63)
m.addConstr(5.28*x0 + 3.53*x1 + 1.44*x2 <= 63)
m.addConstr(0.38*x0 + 1.4*x2 <= 102)
m.addConstr(0.38*x0 + 2.24*x1 + 1.4*x2 <= 102)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of vitamin B6: ", x0.varValue)
    print("Milligrams of calcium: ", x1.varValue)
    print("Milligrams of iron: ", x2.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
