
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
apple_pies = m.addVar(name="apple_pies", lb=0)
sashimi = m.addVar(name="sashimi", lb=0)
fruit_salads = m.addVar(name="fruit_salads", lb=0)

# Set objective function
m.setObjective(6.65 * apple_pies + 8.92 * sashimi + 8.8 * fruit_salads, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * apple_pies + 12 * fruit_salads >= 23, "iron_constraint1")
m.addConstr(10 * sashimi + 1 * fruit_salads >= 26, "cost_constraint1")
m.addConstr(12 * apple_pies + 10 * sashimi <= 83, "iron_constraint2")
m.addConstr(12 * apple_pies + 12 * fruit_salads <= 47, "iron_constraint3")
m.addConstr(12 * apple_pies + 10 * sashimi + 12 * fruit_salads <= 47, "iron_constraint4")
m.addConstr(9 * apple_pies + 3 * sashimi <= 164, "carb_constraint1")
m.addConstr(9 * apple_pies + 3 * sashimi + 14 * fruit_salads <= 143, "carb_constraint2")
m.addConstr(11 * apple_pies + 2 * sashimi <= 215, "tastiness_constraint1")
m.addConstr(2 * sashimi + 10 * fruit_salads <= 88, "tastiness_constraint2")
m.addConstr(11 * apple_pies + 2 * sashimi + 10 * fruit_salads <= 100, "tastiness_constraint3")
m.addConstr(2 * apple_pies + 1 * fruit_salads <= 70, "cost_constraint2")
m.addConstr(2 * apple_pies + 10 * sashimi + 1 * fruit_salads <= 44, "cost_constraint3")


# Resource Constraints (given in the problem description)
m.addConstr(12 * apple_pies + 10 * sashimi + 12 * fruit_salads <= 116, "iron_resource")
m.addConstr(9 * apple_pies + 3 * sashimi + 14 * fruit_salads <= 247, "carb_resource")
m.addConstr(11 * apple_pies + 2 * sashimi + 10 * fruit_salads <= 264, "tastiness_resource")
m.addConstr(2 * apple_pies + 10 * sashimi + 1 * fruit_salads <= 112, "cost_resource")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('apple_pies:', apple_pies.x)
    print('sashimi:', sashimi.x)
    print('fruit_salads:', fruit_salads.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

