
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    apple_pies = model.addVar(name="apple_pies", lb=0)
    sashimi = model.addVar(name="sashimi", lb=0)
    fruit_salads = model.addVar(name="fruit_salads", lb=0)

    # Objective function
    model.setObjective(6.65 * apple_pies + 8.92 * sashimi + 8.8 * fruit_salads, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Iron
    model.addConstr(12 * apple_pies + 10 * sashimi + 12 * fruit_salads <= 116, name="iron_total")
    model.addConstr(apple_pies + fruit_salads >= 23 / 12, name="iron_apple_fruit_min")
    model.addConstr(apple_pies + sashimi <= 83 / 12, name="iron_apple_sashimi_max")
    model.addConstr(apple_pies + fruit_salads <= 47 / 12, name="iron_apple_fruit_max")
    model.addConstr(apple_pies + sashimi + fruit_salads <= 47 / 12, name="iron_total_max")

    # Carbohydrates
    model.addConstr(9 * apple_pies + 3 * sashimi + 14 * fruit_salads <= 143, name="carbohydrates_total_max")
    model.addConstr(9 * apple_pies + 3 * sashimi <= 164, name="carbohydrates_apple_sashimi_max")

    # Tastiness
    model.addConstr(11 * apple_pies + 2 * sashimi <= 215, name="tastiness_apple_sashimi_max")
    model.addConstr(2 * sashimi + 10 * fruit_salads <= 88, name="tastiness_sashimi_fruit_max")
    model.addConstr(11 * apple_pies + 2 * sashimi + 10 * fruit_salads <= 100, name="tastiness_total_max")

    # Cost
    model.addConstr(2 * apple_pies + fruit_salads <= 70, name="cost_apple_fruit_max")
    model.addConstr(2 * apple_pies + 10 * sashimi + fruit_salads <= 44, name="cost_total_max")
    model.addConstr(sashimi + fruit_salads >= 26 / 10, name="cost_sashimi_fruit_min")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Apple Pies: ", apple_pies.varValue)
        print("Sashimi: ", sashimi.varValue)
        print("Fruit Salads: ", fruit_salads.varValue)
    else:
        print("No solution found")

optimize_problem()
