
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
bananas = model.addVar(vtype=GRB.INTEGER, name="bananas")
cherry_pies = model.addVar(vtype=GRB.INTEGER, name="cherry_pies")
ramen = model.addVar(vtype=GRB.INTEGER, name="bowls_of_instant_ramen")
apple_pies = model.addVar(vtype=GRB.INTEGER, name="apple_pies")
chicken_thighs = model.addVar(vtype=GRB.INTEGER, name="chicken_thighs")

# Set objective function
model.setObjective(4 * bananas + 6 * cherry_pies + 2 * ramen + 6 * apple_pies + 9 * chicken_thighs, GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * bananas + 3 * cherry_pies >= 5, "tastiness_constraint1")
model.addConstr(5 * apple_pies + 2 * chicken_thighs >= 8, "tastiness_constraint2")
model.addConstr(3 * cherry_pies + 2 * ramen >= 3, "tastiness_constraint3")
model.addConstr(2 * bananas + 3 * cherry_pies + 2 * chicken_thighs >= 6, "tastiness_constraint4")
model.addConstr(2 * bananas + 3 * cherry_pies + 2 * ramen + 5 * apple_pies + 2 * chicken_thighs >= 6, "tastiness_constraint5")
model.addConstr(3 * cherry_pies + 2 * ramen <= 32, "tastiness_constraint6")
model.addConstr(2 * ramen + 5 * apple_pies <= 35, "tastiness_constraint7")
model.addConstr(2 * bananas + 2 * ramen + 2 * chicken_thighs <= 33, "tastiness_constraint8")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('bananas:', bananas.x)
    print('cherry_pies:', cherry_pies.x)
    print('ramen:', ramen.x)
    print('apple_pies:', apple_pies.x)
    print('chicken_thighs:', chicken_thighs.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

