
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
bananas = m.addVar(name="bananas", vtype=gurobi.GRB.INTEGER)
cherry_pies = m.addVar(name="cherry_pies", vtype=gurobi.GRB.INTEGER)
bowls_of_instant_ramen = m.addVar(name="bowls_of_instant_ramen", vtype=gurobi.GRB.INTEGER)
apple_pies = m.addVar(name="apple_pies", vtype=gurobi.GRB.INTEGER)
chicken_thighs = m.addVar(name="chicken_thighs", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(4 * bananas + 6 * cherry_pies + 2 * bowls_of_instant_ramen + 6 * apple_pies + 9 * chicken_thighs, gurobi.GRB.MINIMIZE)

# Define the constraints
m.addConstr(2 * bananas + 3 * cherry_pies >= 5, name="bananas_cherry_pies_tastiness")
m.addConstr(5 * apple_pies + 2 * chicken_thighs >= 8, name="apple_pies_chicken_thighs_tastiness")
m.addConstr(3 * cherry_pies + 2 * bowls_of_instant_ramen >= 3, name="cherry_pies_bowls_of_instant_ramen_tastiness")
m.addConstr(2 * bananas + 3 * cherry_pies + 2 * chicken_thighs >= 6, name="bananas_cherry_pies_chicken_thighs_tastiness")
m.addConstr(2 * bananas + 3 * cherry_pies + 2 * bowls_of_instant_ramen + 5 * apple_pies + 2 * chicken_thighs >= 6, name="all_tastiness")
m.addConstr(3 * cherry_pies + 2 * bowls_of_instant_ramen <= 32, name="cherry_pies_bowls_of_instant_ramen_max_tastiness")
m.addConstr(2 * bowls_of_instant_ramen + 5 * apple_pies <= 35, name="bowls_of_instant_ramen_apple_pies_max_tastiness")
m.addConstr(2 * bananas + 2 * bowls_of_instant_ramen + 2 * chicken_thighs <= 33, name="bananas_bowls_of_instant_ramen_chicken_thighs_max_tastiness")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Bananas:", bananas.varValue)
    print("Cherry pies:", cherry_pies.varValue)
    print("Bowls of instant ramen:", bowls_of_instant_ramen.varValue)
    print("Apple pies:", apple_pies.varValue)
    print("Chicken thighs:", chicken_thighs.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
