
import gurobipy as gp

# Create a new model
m = gp.Model("employee_scheduling")

# Create variables
dale_hours = m.addVar(lb=0, name="dale_hours")
peggy_hours = m.addVar(lb=0, name="peggy_hours")
laura_hours = m.addVar(lb=0, name="laura_hours")

# Set objective function
m.setObjective(5 * dale_hours + 1 * peggy_hours + 5 * laura_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * peggy_hours + 2 * laura_hours >= 8, "c1")
m.addConstr(7 * dale_hours + 3 * peggy_hours + 2 * laura_hours >= 8, "c2")
m.addConstr(3 * dale_hours + 7 * laura_hours >= 34, "c3")
m.addConstr(3 * dale_hours + 6 * peggy_hours + 7 * laura_hours >= 33, "c4")
m.addConstr(5 * dale_hours + 8 * laura_hours >= 25, "c5")
m.addConstr(5 * dale_hours + 5 * peggy_hours >= 25, "c6")
m.addConstr(5 * peggy_hours + 8 * laura_hours >= 21, "c7")
m.addConstr(5 * dale_hours + 5 * peggy_hours + 8 * laura_hours >= 21, "c8")
m.addConstr(4 * dale_hours + 5 * laura_hours >= 8, "c9")
m.addConstr(4 * dale_hours + 3 * peggy_hours >= 22, "c10")
m.addConstr(3 * peggy_hours + 5 * laura_hours >= 11, "c11")
m.addConstr(4 * dale_hours + 3 * peggy_hours + 5 * laura_hours >= 11, "c12")
m.addConstr(-1 * dale_hours + 5 * laura_hours >= 0, "c13")
m.addConstr(3 * peggy_hours + 2 * laura_hours <= 46, "c14")
m.addConstr(7 * dale_hours + 2 * laura_hours <= 41, "c15")
m.addConstr(6 * peggy_hours + 7 * laura_hours <= 88, "c16")
m.addConstr(3 * dale_hours + 6 * peggy_hours <= 51, "c17")
m.addConstr(3 * dale_hours + 7 * laura_hours <= 89, "c18")
m.addConstr(4 * dale_hours + 3 * peggy_hours <= 36, "c19")
m.addConstr(4 * dale_hours + 3 * peggy_hours + 5 * laura_hours <= 28, "c20")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
