
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=0, name="hours_worked_by_Dale")  # hours worked by Dale
    x1 = model.addVar(lb=0, name="hours_worked_by_Peggy")  # hours worked by Peggy
    x2 = model.addVar(lb=0, name="hours_worked_by_Laura")  # hours worked by Laura

    # Define the objective function
    model.setObjective(5 * x0 + 1 * x1 + 5 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7 * x0 <= 7, name="Dale_likelihood_to_quit")
    model.addConstr(3 * x0 <= 3, name="Dale_organization_score")
    model.addConstr(5 * x0 <= 5, name="Dale_work_quality_rating")
    model.addConstr(4 * x0 <= 4, name="Dale_computer_competence_rating")

    model.addConstr(3 * x1 <= 3, name="Peggy_likelihood_to_quit")
    model.addConstr(6 * x1 <= 6, name="Peggy_organization_score")
    model.addConstr(5 * x1 <= 5, name="Peggy_work_quality_rating")
    model.addConstr(3 * x1 <= 3, name="Peggy_computer_competence_rating")

    model.addConstr(2 * x2 <= 2, name="Laura_likelihood_to_quit")
    model.addConstr(7 * x2 <= 7, name="Laura_organization_score")
    model.addConstr(8 * x2 <= 8, name="Laura_work_quality_rating")
    model.addConstr(5 * x2 <= 5, name="Laura_computer_competence_rating")

    model.addConstr(3 * x1 + 2 * x2 >= 8, name="combined_likelihood_to_quit_Peggy_Laura")
    model.addConstr(7 * x0 + 3 * x1 + 2 * x2 >= 8, name="combined_likelihood_to_quit_all")
    model.addConstr(3 * x0 + 7 * x2 >= 34, name="combined_organization_score_Dale_Laura")
    model.addConstr(3 * x0 + 6 * x1 + 7 * x2 >= 33, name="combined_organization_score_all")
    model.addConstr(5 * x0 + 5 * x2 >= 25, name="combined_work_quality_rating_Dale_Laura")
    model.addConstr(5 * x0 + 5 * x1 >= 25, name="combined_work_quality_rating_Dale_Peggy")
    model.addConstr(5 * x1 + 8 * x2 >= 21, name="combined_work_quality_rating_Peggy_Laura")
    model.addConstr(5 * x0 + 5 * x1 + 8 * x2 >= 21, name="combined_work_quality_rating_all")
    model.addConstr(4 * x0 + 5 * x2 >= 8, name="combined_computer_competence_rating_Dale_Laura")
    model.addConstr(4 * x0 + 3 * x1 >= 22, name="combined_computer_competence_rating_Dale_Peggy")
    model.addConstr(3 * x1 + 5 * x2 >= 11, name="combined_computer_competence_rating_Peggy_Laura")
    model.addConstr(4 * x0 + 3 * x1 + 5 * x2 >= 11, name="combined_computer_competence_rating_all")

    model.addConstr(-x0 + 5 * x2 >= 0, name="Dale_Laura_constraint")
    model.addConstr(3 * x1 + 2 * x2 <= 46, name="combined_likelihood_to_quit_Peggy_Laura_upper")
    model.addConstr(7 * x0 + 2 * x2 <= 41, name="combined_likelihood_to_quit_Dale_Laura_upper")
    model.addConstr(6 * x1 + 7 * x2 <= 88, name="combined_organization_score_Peggy_Laura_upper")
    model.addConstr(3 * x0 + 6 * x1 <= 51, name="combined_organization_score_Dale_Peggy_upper")
    model.addConstr(3 * x0 + 7 * x2 <= 89, name="combined_organization_score_Dale_Laura_upper")
    model.addConstr(4 * x0 + 3 * x1 <= 36, name="combined_computer_competence_rating_Dale_Peggy_upper")
    model.addConstr(4 * x0 + 3 * x1 + 5 * x2 <= 28, name="combined_computer_competence_rating_all_upper")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Dale: ", x0.varValue)
        print("Hours worked by Peggy: ", x1.varValue)
        print("Hours worked by Laura: ", x2.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
