
from gurobipy import Model, GRB

# Create a new model
m = Model("food_optimization")

# Create variables
potatoes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")
fruit_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")
hot_dogs = m.addVar(lb=0, vtype=GRB.INTEGER, name="hot_dogs")

# Set objective function
m.setObjective(3.74 * potatoes + 5.88 * fruit_salads + 8.09 * hot_dogs, GRB.MINIMIZE)

# Add constraints
m.addConstr(19 * potatoes + 9 * fruit_salads >= 29, "protein_constraint1")
m.addConstr(9 * fruit_salads + 3 * hot_dogs >= 30, "protein_constraint2")
m.addConstr(19 * potatoes + 9 * fruit_salads + 3 * hot_dogs >= 46, "protein_constraint3")
m.addConstr(19 * potatoes + 9 * fruit_salads + 3 * hot_dogs >= 46, "protein_constraint4") # Redundant constraint

m.addConstr(18 * potatoes + 10 * hot_dogs >= 30, "fat_constraint1")
m.addConstr(18 * potatoes + 16 * fruit_salads + 10 * hot_dogs >= 30, "fat_constraint2")

m.addConstr(6 * potatoes + 3 * fruit_salads >= 29, "cost_constraint1")
m.addConstr(3 * fruit_salads + 17 * hot_dogs >= 41, "cost_constraint2")
m.addConstr(6 * potatoes + 17 * hot_dogs >= 17, "cost_constraint3")
m.addConstr(6 * potatoes + 3 * fruit_salads + 17 * hot_dogs >= 17, "cost_constraint4")

m.addConstr(26 * fruit_salads + 22 * hot_dogs >= 37, "carbs_constraint1")
m.addConstr(1 * potatoes + 22 * hot_dogs >= 23, "carbs_constraint2")
m.addConstr(1 * potatoes + 26 * fruit_salads + 22 * hot_dogs >= 23, "carbs_constraint3")

m.addConstr(fruit_salads - 5 * hot_dogs >= 0, "additional_constraint1")
m.addConstr(9 * fruit_salads + 3 * hot_dogs <= 95, "protein_constraint5")
m.addConstr(6 * potatoes + 3 * fruit_salads + 17 * hot_dogs <= 57, "cost_constraint5")


# Resource Constraints (using the provided dictionary would make this more flexible)
m.addConstr(19 * potatoes + 9 * fruit_salads + 3 * hot_dogs <= 155, "protein_limit")
m.addConstr(18 * potatoes + 16 * fruit_salads + 10 * hot_dogs <= 130, "fat_limit")
m.addConstr(6 * potatoes + 3 * fruit_salads + 17 * hot_dogs <= 133, "cost_limit") # Note: This is redundant given cost_constraint5
m.addConstr(1 * potatoes + 26 * fruit_salads + 22 * hot_dogs <= 141, "carb_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('potatoes:', potatoes.x)
    print('fruit_salads:', fruit_salads.x)
    print('hot_dogs:', hot_dogs.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
