
import gurobipy as gp

# Create a new model
m = gp.Model("office_supplies")

# Create variables
red_highlighters = m.addVar(vtype=gp.GRB.INTEGER, name="red_highlighters")
staplers = m.addVar(vtype=gp.GRB.INTEGER, name="staplers")
manila_envelopes = m.addVar(vtype=gp.GRB.INTEGER, name="manila_envelopes")
monochrome_printers = m.addVar(vtype=gp.GRB.INTEGER, name="monochrome_printers")

# Set objective function
m.setObjective(4.5 * red_highlighters + 5.52 * staplers + 1.67 * manila_envelopes + 4.26 * monochrome_printers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * red_highlighters + 5 * monochrome_printers >= 25, "c1")
m.addConstr(5 * manila_envelopes + 5 * monochrome_printers >= 21, "c2")
m.addConstr(13 * staplers + 5 * manila_envelopes >= 18, "c3")
m.addConstr(10 * red_highlighters + 13 * staplers >= 28, "c4")
m.addConstr(10 * red_highlighters + 5 * manila_envelopes >= 18, "c5")
m.addConstr(10 * red_highlighters + 13 * staplers + 5 * monochrome_printers >= 14, "c6")
m.addConstr(10 * red_highlighters + 5 * manila_envelopes + 5 * monochrome_printers >= 14, "c7")
m.addConstr(10 * red_highlighters + 13 * staplers + 5 * monochrome_printers >= 16, "c8")
m.addConstr(10 * red_highlighters + 5 * manila_envelopes + 5 * monochrome_printers >= 16, "c9")

m.addConstr(1 * red_highlighters + 12 * monochrome_printers <= 71, "c10")
m.addConstr(5 * staplers + 12 * monochrome_printers <= 136, "c11")
m.addConstr(6 * manila_envelopes + 12 * monochrome_printers <= 181, "c12")
m.addConstr(5 * staplers + 6 * manila_envelopes + 12 * monochrome_printers <= 48, "c13")
m.addConstr(1 * red_highlighters + 6 * manila_envelopes + 12 * monochrome_printers <= 187, "c14")
m.addConstr(1 * red_highlighters + 5 * staplers + 6 * manila_envelopes + 12 * monochrome_printers <= 187, "c15")


m.addConstr(10 * red_highlighters + 5 * monochrome_printers <= 82, "c16")
m.addConstr(5 * manila_envelopes + 5 * monochrome_printers <= 105, "c17")
m.addConstr(13 * staplers + 5 * manila_envelopes <= 57, "c18")
m.addConstr(13 * staplers + 5 * monochrome_printers <= 74, "c19")
m.addConstr(10 * red_highlighters + 13 * staplers + 5 * monochrome_printers <= 36, "c20")
m.addConstr(10 * red_highlighters + 13 * staplers + 5 * manila_envelopes <= 96, "c21")
m.addConstr(10 * red_highlighters + 13 * staplers + 5 * manila_envelopes + 5 * monochrome_printers <= 96, "c22")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

