
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="red_highlighters", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="staplers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="manila_envelopes", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="monochrome_printers", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(4.5*x0 + 5.52*x1 + 1.67*x2 + 4.26*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x0 + 5*x1 + 6*x2 + 12*x3 <= 189, name="usefulness_rating")
    model.addConstr(10*x0 + 13*x1 + 5*x2 + 5*x3 <= 113, name="dollar_cost")

    model.addConstr(10*x0 + 5*x3 >= 25, name="cost_red_monochrome")
    model.addConstr(5*x2 + 5*x3 >= 21, name="cost_manila_monochrome")
    model.addConstr(13*x1 + 5*x2 >= 18, name="cost_staplers_manila")
    model.addConstr(10*x0 + 13*x1 >= 28, name="cost_red_staplers")
    model.addConstr(10*x0 + 5*x2 >= 18, name="cost_red_manila")
    model.addConstr(10*x0 + 13*x1 + 5*x3 >= 14, name="cost_red_staplers_monochrome")
    model.addConstr(10*x0 + 5*x2 + 5*x3 >= 14, name="cost_red_manila_monochrome")
    model.addConstr(x0 + x1 + x3 >= 16, name="cost_red_staplers_monochrome_total")
    model.addConstr(x0 + x2 + x3 >= 16, name="cost_red_manila_monochrome_total")

    model.addConstr(x0 + 12*x3 <= 71, name="usefulness_red_monochrome")
    model.addConstr(5*x1 + 12*x3 <= 136, name="usefulness_staplers_monochrome")
    model.addConstr(6*x2 + 12*x3 <= 181, name="usefulness_manila_monochrome")
    model.addConstr(5*x1 + 6*x2 + 12*x3 <= 48, name="usefulness_staplers_manila_monochrome")
    model.addConstr(x0 + 6*x2 + 12*x3 <= 187, name="usefulness_red_manila_monochrome")
    model.addConstr(x0 + 5*x1 + 6*x2 + 12*x3 <= 187, name="usefulness_total")

    model.addConstr(10*x0 + 5*x3 <= 82, name="budget_red_monochrome")
    model.addConstr(5*x2 + 5*x3 <= 105, name="budget_manila_monochrome")
    model.addConstr(13*x1 + 5*x2 <= 57, name="budget_staplers_manila")
    model.addConstr(13*x1 + 5*x3 <= 74, name="budget_staplers_monochrome")
    model.addConstr(10*x0 + 13*x1 + 5*x3 <= 36, name="budget_red_staplers_monochrome")
    model.addConstr(x0 + x1 + x2 <= 96, name="budget_red_staplers_manila")
    model.addConstr(x0 + x1 + x2 + x3 <= 96, name="budget_total")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Red highlighters: ", x0.varValue)
        print("Staplers: ", x1.varValue)
        print("Manila envelopes: ", x2.varValue)
        print("Monochrome printers: ", x3.varValue)
    else:
        print("Model is infeasible")

solve_optimization_problem()
