
from gurobipy import *

# Create a model
m = Model("Organization_Scores")

# Define variables
J = m.addVar(vtype=GRB.INTEGER, name="John")
N = m.addVar(vtype=GRB.INTEGER, name="Jean")
Bb = m.addVar(vtype=GRB.CONTINUOUS, name="Bobby")
M = m.addVar(vtype=GRB.CONTINUOUS, name="Mary")
L = m.addVar(vtype=GRB.INTEGER, name="Bill")
La = m.addVar(vtype=GRB.INTEGER, name="Laura")

# Organization score constraints
m.addConstr(J + N + Bb >= 34, "Organization_Score_1") # Example constraint for demonstration
m.addConstr(Bb + L <= 120, "Organization_Score_2")
m.addConstr(J + M <= 157, "Organization_Score_3")
m.addConstr(N + L <= 173, "Organization_Score_4")
m.addConstr(M + L <= 180, "Organization_Score_5")
m.addConstr(N + La <= 90, "Organization_Score_6")
m.addConstr(L + La <= 124, "Organization_Score_7")
m.addConstr(J + Bb <= 41, "Organization_Score_8")
m.addConstr(J + La <= 66, "Organization_Score_9")
m.addConstr(Bb + La <= 104, "Organization_Score_10")
m.addConstr(J + N + L <= 185, "Organization_Score_11")
m.addConstr(J + M + La <= 162, "Organization_Score_12")
m.addConstr(J + N + Bb + M + L + La <= 162, "Total_Organization_Score")

# Add more constraints here based on the problem description

# Objective function: Maximize total organization score for demonstration
m.setObjective(J + N + Bb + M + L + La, GRB.MAXIMIZE)

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))

print('Obj: %g' % m.objVal)
