
import gurobi as gp

# Define the variables
hours_worked_by_John = gp.Var(name="hours_worked_by_John", vtype=gp.GRB.INTEGER)
hours_worked_by_Jean = gp.Var(name="hours_worked_by_Jean", vtype=gp.GRB.INTEGER)
hours_worked_by_Bobby = gp.Var(name="hours_worked_by_Bobby")
hours_worked_by_Mary = gp.Var(name="hours_worked_by_Mary")
hours_worked_by_Bill = gp.Var(name="hours_worked_by_Bill", vtype=gp.GRB.INTEGER)
hours_worked_by_Laura = gp.Var(name="hours_worked_by_Laura", vtype=gp.GRB.INTEGER)

# Define the model
model = gp.Model()

# Objective function
model.setObjective(7 * hours_worked_by_John + 5 * hours_worked_by_Jean + 4 * hours_worked_by_Bobby + 
                   2 * hours_worked_by_Mary + 4 * hours_worked_by_Bill + 3 * hours_worked_by_Laura, 
                   gp.GRB.MAXIMIZE)

# Constraints
# John's attributes
model.addConstr(16 * hours_worked_by_John <= 359, "r0_John")
model.addConstr(9 * hours_worked_by_John <= 390, "r1_John")
model.addConstr(7 * hours_worked_by_John <= 910, "r2_John")
model.addConstr(1 * hours_worked_by_John <= 828, "r3_John")
model.addConstr(25 * hours_worked_by_John <= 204, "r4_John")

# Jean's attributes
model.addConstr(9 * hours_worked_by_Jean <= 359, "r0_Jean")
model.addConstr(1 * hours_worked_by_Jean <= 390, "r1_Jean")
model.addConstr(23 * hours_worked_by_Jean <= 910, "r2_Jean")
model.addConstr(17 * hours_worked_by_Jean <= 828, "r3_Jean")
model.addConstr(17 * hours_worked_by_Jean <= 204, "r4_Jean")

# Bobby's attributes
model.addConstr(27 * hours_worked_by_Bobby <= 359, "r0_Bobby")
model.addConstr(18 * hours_worked_by_Bobby <= 390, "r1_Bobby")
model.addConstr(25 * hours_worked_by_Bobby <= 910, "r2_Bobby")
model.addConstr(15 * hours_worked_by_Bobby <= 828, "r3_Bobby")
model.addConstr(7 * hours_worked_by_Bobby <= 204, "r4_Bobby")

# Mary's attributes
model.addConstr(17 * hours_worked_by_Mary <= 359, "r0_Mary")
model.addConstr(23 * hours_worked_by_Mary <= 390, "r1_Mary")
model.addConstr(13 * hours_worked_by_Mary <= 910, "r2_Mary")
model.addConstr(26 * hours_worked_by_Mary <= 828, "r3_Mary")
model.addConstr(26 * hours_worked_by_Mary <= 204, "r4_Mary")

# Bill's attributes
model.addConstr(17 * hours_worked_by_Bill <= 359, "r0_Bill")
model.addConstr(22 * hours_worked_by_Bill <= 390, "r1_Bill")
model.addConstr(15 * hours_worked_by_Bill <= 910, "r2_Bill")
model.addConstr(5 * hours_worked_by_Bill <= 828, "r3_Bill")
model.addConstr(29 * hours_worked_by_Bill <= 204, "r4_Bill")

# Laura's attributes
model.addConstr(21 * hours_worked_by_Laura <= 359, "r0_Laura")
model.addConstr(1 * hours_worked_by_Laura <= 390, "r1_Laura")
model.addConstr(20 * hours_worked_by_Laura <= 910, "r2_Laura")
model.addConstr(8 * hours_worked_by_Laura <= 828, "r3_Laura")
model.addConstr(26 * hours_worked_by_Laura <= 204, "r4_Laura")

# Paperwork competence rating constraints
model.addConstr(9 * hours_worked_by_Jean + 27 * hours_worked_by_Bobby >= 35, "paperwork_Jean_Bobby")
model.addConstr(16 * hours_worked_by_John + 17 * hours_worked_by_Mary >= 44, "paperwork_John_Mary")
model.addConstr(9 * hours_worked_by_Jean + 21 * hours_worked_by_Laura >= 32, "paperwork_Jean_Laura")
model.addConstr(27 * hours_worked_by_Bobby + 17 * hours_worked_by_Mary >= 46, "paperwork_Bobby_Mary")
model.addConstr(16 * hours_worked_by_John + 9 * hours_worked_by_Jean + 21 * hours_worked_by_Laura >= 50, "paperwork_John_Jean_Laura")
model.addConstr(9 * hours_worked_by_Jean + 27 * hours_worked_by_Bobby + 17 * hours_worked_by_Mary >= 50, "paperwork_Jean_Bobby_Mary")
model.addConstr(16 * hours_worked_by_John + 17 * hours_worked_by_Mary + 21 * hours_worked_by_Laura >= 50, "paperwork_John_Mary_Laura")
model.addConstr(27 * hours_worked_by_Bobby + 17 * hours_worked_by_Mary + 21 * hours_worked_by_Laura >= 50, "paperwork_Bobby_Mary_Laura")
model.addConstr(16 * hours_worked_by_John + 9 * hours_worked_by_Jean + 21 * hours_worked_by_Laura >= 55, "paperwork_John_Jean_Laura_55")
model.addConstr(9 * hours_worked_by_Jean + 27 * hours_worked_by_Bobby + 17 * hours_worked_by_Mary >= 55, "paperwork_Jean_Bobby_Mary_55")
model.addConstr(16 * hours_worked_by_John + 17 * hours_worked_by_Mary + 21 * hours_worked_by_Laura >= 55, "paperwork_John_Mary_Laura_55")
model.addConstr(27 * hours_worked_by_Bobby + 17 * hours_worked_by_Mary + 21 * hours_worked_by_Laura >= 55, "paperwork_Bobby_Mary_Laura_55")

# Likelihood to quit index constraints
model.addConstr(9 * hours_worked_by_John + 18 * hours_worked_by_Bobby >= 61, "quit_John_Bobby")
model.addConstr(1 * hours_worked_by_Jean + 22 * hours_worked_by_Bill >= 49, "quit_Jean_Bill")
model.addConstr(22 * hours_worked_by_Bill + 1 * hours_worked_by_Laura >= 65, "quit_Bill_Laura")
model.addConstr(1 * hours_worked_by_Jean + 1 * hours_worked_by_Laura >= 39, "quit_Jean_Laura")
model.addConstr(9 * hours_worked_by_John + 1 * hours_worked_by_Jean >= 35, "quit_John_Jean")

# Work quality rating constraints
model.addConstr(7 * hours_worked_by_John + 13 * hours_worked_by_Mary >= 51, "quality_John_Mary")
model.addConstr(7 * hours_worked_by_John + 25 * hours_worked_by_Bobby >= 108, "quality_John_Bobby")
model.addConstr(25 * hours_worked_by_Bobby + 20 * hours_worked_by_Laura >= 73, "quality_Bobby_Laura")
model.addConstr(23 * hours_worked_by_Jean + 25 * hours_worked_by_Bobby >= 100, "quality_Jean_Bobby")

# Computer competence rating constraints
model.addConstr(15 * hours_worked_by_Bobby + 26 * hours_worked_by_Mary >= 135, "computer_Bobby_Mary")
model.addConstr(1 * hours_worked_by_John + 8 * hours_worked_by_Laura >= 58, "computer_John_Laura")

# Organization score constraints
model.addConstr(25 * hours_worked_by_John + 29 * hours_worked_by_Bill >= 34, "organization_John_Bill")
model.addConstr(26 * hours_worked_by_Mary + 26 * hours_worked_by_Laura >= 19, "organization_Mary_Laura")

# Bounds
model.addConstr(17 * hours_worked_by_Mary + 26 * hours_worked_by_Laura <= 316, "bounds_Mary_Laura")
model.addConstr(21 * hours_worked_by_Bill + 20 * hours_worked_by_Laura <= 65, "bounds_Bill_Laura")
model.addConstr(27 * hours_worked_by_Bobby + 20 * hours_worked_by_Laura <= 325, "bounds_Bobby_Laura")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by John: {hours_worked_by_John.varValue}")
    print(f"Hours worked by Jean: {hours_worked_by_Jean.varValue}")
    print(f"Hours worked by Bobby: {hours_worked_by_Bobby.varValue}")
    print(f"Hours worked by Mary: {hours_worked_by_Mary.varValue}")
    print(f"Hours worked by Bill: {hours_worked_by_Bill.varValue}")
    print(f"Hours worked by Laura: {hours_worked_by_Laura.varValue}")
else:
    print("No optimal solution found.")
