
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
eggs = m.addVar(vtype=GRB.CONTINUOUS, name="eggs")
hot_dogs = m.addVar(vtype=GRB.CONTINUOUS, name="hot_dogs")

# Set the objective function
m.setObjective(5.97 * eggs + 9.26 * hot_dogs, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * eggs + 6 * hot_dogs >= 12, "min_fiber")
m.addConstr(1 * eggs + 9 * hot_dogs >= 4, "min_sourness")
m.addConstr(-3 * eggs + 2 * hot_dogs >= 0, "additional_constraint")
m.addConstr(7 * eggs + 6 * hot_dogs <= 26, "max_fiber")
m.addConstr(1 * eggs + 9 * hot_dogs <= 21, "max_sourness")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Eggs: {eggs.x}")
    print(f"Hot Dogs: {hot_dogs.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
