
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    eggs = model.addVar(lb=0, name="eggs", vtype=gurobi.GRB.CONTINUOUS)
    hot_dogs = model.addVar(lb=0, name="hot_dogs", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(5.97 * eggs + 9.26 * hot_dogs, gurobi.GRB.MAXIMIZE)

    # Constraints
    # At least 12 grams of fiber
    model.addConstraint(7 * eggs + 6 * hot_dogs >= 12, name="fiber_constraint")

    # Total sourness index at least 4
    model.addConstraint(eggs + 9 * hot_dogs >= 4, name="sourness_index_constraint")

    # -3 * eggs + 2 * hot dogs >= 0
    model.addConstraint(-3 * eggs + 2 * hot_dogs >= 0, name="linear_constraint")

    # Total fiber not more than 26 (from r0)
    model.addConstraint(7 * eggs + 6 * hot_dogs <= 26, name="total_fiber_constraint")

    # Total sourness index not more than 21
    model.addConstraint(eggs + 9 * hot_dogs <= 21, name="total_sourness_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Eggs: {eggs.varValue}")
        print(f"Hot Dogs: {hot_dogs.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
