
from gurobipy import Model, GRB

# Create a new model
model = Model("calcium_optimization")

# Create variables
sashimi = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sashimi")
kale_salads = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kale_salads")
corn_cobs = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="corn_cobs")
steaks = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="steaks")
kiwis = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kiwis")

# Set objective function
model.setObjective(8 * sashimi + 5 * kale_salads + 8 * corn_cobs + 9 * steaks + 5 * kiwis, GRB.MAXIMIZE)

# Add constraints
model.addConstr(26 * kale_salads + 5 * steaks + 1 * kiwis >= 32, "calcium_constraint1")
model.addConstr(2 * corn_cobs + 5 * steaks <= 81, "calcium_constraint2")
model.addConstr(17 * sashimi + 1 * kiwis <= 48, "calcium_constraint3")
model.addConstr(17 * sashimi + 2 * corn_cobs + 1 * kiwis <= 110, "calcium_constraint4")
model.addConstr(17 * sashimi + 26 * kale_salads + 2 * corn_cobs + 5 * steaks + 1 * kiwis <= 176, "calcium_constraint5")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")

