
import gurobi as gp

# Define the model
m = gp.Model("calcium_optimization")

# Define the variables
sashimi = m.addVar(name="sashimi", lb=0)  # lower bound 0, can be fractional
kale_salads = m.addVar(name="kale_salads", lb=0)  # lower bound 0, can be fractional
corn_cobs = m.addVar(name="corn_cobs", lb=0)  # lower bound 0, can be fractional
steaks = m.addVar(name="steaks", lb=0)  # lower bound 0, can be fractional
kiwis = m.addVar(name="kiwis", lb=0)  # lower bound 0, can be fractional

# Objective function: maximize 8s + 5k + 8c + 9st + 5ki
m.setObjective(8 * sashimi + 5 * kale_salads + 8 * corn_cobs + 9 * steaks + 5 * kiwis, gp.GRB.MAXIMIZE)

# Constraints
# Total calcium constraint
m.addConstr(17 * sashimi + 26 * kale_salads + 2 * corn_cobs + 5 * steaks + 1 * kiwis <= 176, "total_calcium")

# Calcium from kale salads, steaks, and kiwis >= 32
m.addConstr(26 * kale_salads + 5 * steaks + 1 * kiwis >= 32, "min_calcium_from_kst_ki")

# Calcium from corn cobs and steaks <= 81
m.addConstr(2 * corn_cobs + 5 * steaks <= 81, "max_calcium_from_cst")

# Calcium from sashimi and kiwis <= 48
m.addConstr(17 * sashimi + 1 * kiwis <= 48, "max_calcium_from_ski")

# Calcium from sashimi, corn cobs, and kiwis <= 110
m.addConstr(17 * sashimi + 2 * corn_cobs + 1 * kiwis <= 110, "max_calcium_from_sck_ki")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Sashimi: ", sashimi.x)
    print("Kale Salads: ", kale_salads.x)
    print("Corn Cobs: ", corn_cobs.x)
    print("Steaks: ", steaks.x)
    print("Kiwis: ", kiwis.x)
else:
    print("The model is infeasible")
