
import gurobipy as gp

# Create a new model
m = gp.Model("optimize_work_hours")

# Create variables
paul_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")
peggy_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy_hours")

# Set objective function
m.setObjective(7.41 * paul_hours + 3.98 * peggy_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * paul_hours + 6 * peggy_hours >= 34, "dollar_cost_min")
m.addConstr(6 * paul_hours + 5 * peggy_hours >= 31, "productivity_min")
m.addConstr(-9 * paul_hours + 3 * peggy_hours >= 0, "custom_constraint")
m.addConstr(7 * paul_hours + 6 * peggy_hours <= 75, "dollar_cost_max")
m.addConstr(6 * paul_hours + 5 * peggy_hours <= 38, "productivity_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Paul's hours: {paul_hours.x}")
    print(f"  Peggy's hours: {peggy_hours.x}")
    print(f"  Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

