
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
hours_worked_by_Paul = m.addVar(lb=0, name="hours_worked_by_Paul", vtype=GRB.CONTINUOUS)
hours_worked_by_Peggy = m.addVar(lb=0, name="hours_worked_by_Peggy", vtype=GRB.CONTINUOUS)

# Set the objective function
m.setObjective(7.41 * hours_worked_by_Paul + 3.98 * hours_worked_by_Peggy, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * hours_worked_by_Paul + 6 * hours_worked_by_Peggy >= 34, name="min_dollar_cost")
m.addConstr(6 * hours_worked_by_Paul + 5 * hours_worked_by_Peggy >= 31, name="min_productivity_rating")
m.addConstr(-9 * hours_worked_by_Paul + 3 * hours_worked_by_Peggy >= 0, name="hours_constraint")
m.addConstr(7 * hours_worked_by_Paul + 6 * hours_worked_by_Peggy <= 75, name="max_dollar_cost")
m.addConstr(6 * hours_worked_by_Paul + 5 * hours_worked_by_Peggy <= 38, name="max_productivity_rating")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {hours_worked_by_Paul.x}")
    print(f"Hours worked by Peggy: {hours_worked_by_Peggy.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found")
