
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
hours_worked_by_paul = m.addVar(name="hours_worked_by_paul", lb=0)  # Assuming hours cannot be negative
hours_worked_by_peggy = m.addVar(name="hours_worked_by_peggy", lb=0)  # Assuming hours cannot be negative

# Objective function: Maximize 7.41 * hours_worked_by_paul + 3.98 * hours_worked_by_peggy
m.setObjective(7.41 * hours_worked_by_paul + 3.98 * hours_worked_by_peggy, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(7 * hours_worked_by_paul + 6 * hours_worked_by_peggy >= 34, name="min_dollar_cost")
m.addConstr(6 * hours_worked_by_paul + 5 * hours_worked_by_peggy >= 31, name="min_productivity")
m.addConstr(-9 * hours_worked_by_paul + 3 * hours_worked_by_peggy >= 0, name="peggy_vs_paul")
m.addConstr(7 * hours_worked_by_paul + 6 * hours_worked_by_peggy <= 75, name="max_dollar_cost")
m.addConstr(6 * hours_worked_by_paul + 5 * hours_worked_by_peggy <= 38, name="max_productivity")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Paul: {hours_worked_by_paul.varValue}")
    print(f"Hours worked by Peggy: {hours_worked_by_peggy.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
