
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
b12 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="B12")
b4 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="B4")
c = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="C")

# Set objective function
model.setObjective(6.04 * b12 + 8.67 * b4 + 8.34 * c, GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.43 * b12 + 0.11 * b4 >= 21, "c1")
model.addConstr(0.43 * b12 + 0.11 * b4 <= 104, "c2")
model.addConstr(0.43 * b12 + 0.11 * b4 + 0.02 * c <= 137, "c3")  # Corrected RHS based on provided resource limit


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('B12: %g' % b12.x)
    print('B4: %g' % b4.x)
    print('C: %g' % c.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)

