
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
milligrams_vitamin_B12 = model.addVar(name="milligrams_vitamin_B12", lb=0)  # No upper bound given
milligrams_vitamin_B4 = model.addVar(name="milligrams_vitamin_B4", lb=0)  # No upper bound given
milligrams_vitamin_C = model.addVar(name="milligrams_vitamin_C", lb=0)  # No upper bound given

# Objective function
model.setObjective(6.04 * milligrams_vitamin_B12 + 8.67 * milligrams_vitamin_B4 + 8.34 * milligrams_vitamin_C, gurobi.GRB.MAXIMIZE)

# Constraints
r0_x0 = 0.43
r0_x1 = 0.11
r0_x2 = 0.02
upper_bound_r0 = 137

model.addConstr(r0_x0 * milligrams_vitamin_B12 + r0_x1 * milligrams_vitamin_B4 >= 21, name="constraint_B12_B4_min")
model.addConstr(r0_x0 * milligrams_vitamin_B12 + r0_x1 * milligrams_vitamin_B4 <= 104, name="constraint_B12_B4_max")
model.addConstr(r0_x0 * milligrams_vitamin_B12 + r0_x1 * milligrams_vitamin_B4 + r0_x2 * milligrams_vitamin_C <= upper_bound_r0, name="constraint_all")

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Milligrams of vitamin B12: {milligrams_vitamin_B12.x}")
    print(f"Milligrams of vitamin B4: {milligrams_vitamin_B4.x}")
    print(f"Milligrams of vitamin C: {milligrams_vitamin_C.x}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
