
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_e = m.addVar(lb=0, name="vitamin_e")
potassium = m.addVar(lb=0, name="potassium")
vitamin_b9 = m.addVar(lb=0, name="vitamin_b9")
zinc = m.addVar(lb=0, name="zinc")

# Set objective function
m.setObjective(6.98 * vitamin_e + 2.26 * potassium + 3.5 * vitamin_b9 + 2.08 * zinc, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * vitamin_e + 8 * potassium + 5 * vitamin_b9 + 5 * zinc <= 167, "r0_upper_bound")  # Energy stability index
m.addConstr(3 * vitamin_e + 11 * potassium + 2 * vitamin_b9 + 1 * zinc <= 282, "r1_upper_bound")  # Muscle growth index

m.addConstr(11 * potassium + 1 * zinc >= 35, "muscle_growth_potassium_zinc")
m.addConstr(2 * vitamin_b9 + 1 * zinc >= 50, "muscle_growth_b9_zinc")
m.addConstr(11 * potassium + 2 * vitamin_b9 + 1 * zinc >= 42, "muscle_growth_potassium_b9_zinc")

m.addConstr(5 * vitamin_b9 + 5 * zinc <= 146, "energy_stability_b9_zinc")
m.addConstr(6 * vitamin_e + 8 * potassium <= 167, "energy_stability_e_potassium")
m.addConstr(6 * vitamin_e + 5 * vitamin_b9 <= 148, "energy_stability_e_b9")
m.addConstr(6 * vitamin_e + 8 * potassium + 5 * zinc <= 121, "energy_stability_e_potassium_zinc")
m.addConstr(6 * vitamin_e + 8 * potassium + 5 * vitamin_b9 + 5 * zinc <= 121, "energy_stability_all")

m.addConstr(3 * vitamin_e + 11 * potassium <= 276, "muscle_growth_e_potassium")
m.addConstr(3 * vitamin_e + 1 * zinc <= 179, "muscle_growth_e_zinc")
m.addConstr(11 * potassium + 2 * vitamin_b9 <= 117, "muscle_growth_potassium_b9")
m.addConstr(2 * vitamin_b9 + 1 * zinc <= 152, "muscle_growth_b9_zinc_max")
m.addConstr(3 * vitamin_e + 11 * potassium + 2 * vitamin_b9 + 1 * zinc <= 152, "muscle_growth_all")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

