
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Define variables
x0 = m.addVar(name="Vitamin_E", lb=0)
x1 = m.addVar(name="Potassium", lb=0)
x2 = m.addVar(name="Vitamin_B9", lb=0)
x3 = m.addVar(name="Zinc", lb=0)

# Set the objective function
m.setObjective(6.98*x0 + 2.26*x1 + 3.5*x2 + 2.08*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x1 + 1*x3 >= 35)
m.addConstr(2*x2 + 1*x3 >= 50)
m.addConstr(11*x1 + 2*x2 + 1*x3 >= 42)
m.addConstr(5*x2 + 5*x3 <= 146)
m.addConstr(6*x0 + 8*x1 <= 167)
m.addConstr(6*x0 + 5*x2 <= 148)
m.addConstr(6*x0 + 8*x1 + 5*x3 <= 121)
m.addConstr(6*x0 + 8*x1 + 5*x2 + 5*x3 <= 121)
m.addConstr(3*x0 + 11*x1 <= 276)
m.addConstr(3*x0 + 1*x3 <= 179)
m.addConstr(11*x1 + 2*x2 <= 117)
m.addConstr(2*x2 + 1*x3 <= 152)
m.addConstr(3*x0 + 11*x1 + 2*x2 + 1*x3 <= 152)

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vitamin E: {x0.x}")
    print(f"Potassium: {x1.x}")
    print(f"Vitamin B9: {x2.x}")
    print(f"Zinc: {x3.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
