
import gurobi

def optimize_nutrition():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="vitamin_E", lb=0)  # milligrams of vitamin E
    x1 = model.addVar(name="potassium", lb=0)  # milligrams of potassium
    x2 = model.addVar(name="vitamin_B9", lb=0)  # milligrams of vitamin B9
    x3 = model.addVar(name="zinc", lb=0)  # milligrams of zinc

    # Objective function
    model.setObjective(6.98*x0 + 2.26*x1 + 3.5*x2 + 2.08*x3, gurobi.GRB.MAXIMIZE)

    # Index Constraints
    model.addConstraint(6*x0 <= 6)  # Energy stability index for vitamin E
    model.addConstraint(3*x0 <= 3)  # Muscle growth index for vitamin E
    model.addConstraint(8*x1 <= 8)  # Energy stability index for potassium
    model.addConstraint(11*x1 <= 11)  # Muscle growth index for potassium
    model.addConstraint(5*x2 <= 5)  # Energy stability index for vitamin B9
    model.addConstraint(2*x2 <= 2)  # Muscle growth index for vitamin B9
    model.addConstraint(5*x3 <= 5)  # Energy stability index for zinc
    model.addConstraint(x3 <= 1)  # Muscle growth index for zinc

    # Combined Constraints
    model.addConstraint(11*x1 + x3 >= 35)
    model.addConstraint(2*x2 + x3 >= 50)
    model.addConstraint(11*x1 + 2*x2 + x3 >= 42)
    model.addConstraint(5*x2 + 5*x3 <= 146)
    model.addConstraint(6*x0 + 8*x1 <= 167)
    model.addConstraint(6*x0 + 5*x2 <= 148)
    model.addConstraint(6*x0 + 8*x1 + 5*x3 <= 121)
    model.addConstraint(6*x0 + 8*x1 + 5*x2 + 5*x3 <= 121)
    model.addConstraint(3*x0 + 11*x1 <= 276)
    model.addConstraint(3*x0 + x3 <= 179)
    model.addConstraint(11*x1 + 2*x2 <= 117)
    model.addConstraint(2*x2 + x3 <= 152)
    model.addConstraint(3*x0 + 11*x1 + 2*x2 + x3 <= 152)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Vitamin E: {x0.varValue}")
        print(f"Potassium: {x1.varValue}")
        print(f"Vitamin B9: {x2.varValue}")
        print(f"Zinc: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_nutrition()
