
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
vitamin_D = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_D")
vitamin_B1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_B1")
potassium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potassium")
vitamin_K = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_K")
vitamin_B4 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_B4")
magnesium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="magnesium")

# Set objective function
model.setObjective(3 * vitamin_D + 1 * vitamin_B1 + 8 * potassium + 8 * vitamin_K + 3 * vitamin_B4 + 2 * magnesium, GRB.MINIMIZE)

# Add constraints based on cardiovascular support index
cardiovascular_support = {
    'r0': {'upper_bound': 275, 'coefficients': [22, 9, 15, 15, 2, 7]},
}

for resource, data in cardiovascular_support.items():
    model.addConstr(
        data['coefficients'][0] * vitamin_D +
        data['coefficients'][1] * vitamin_B1 +
        data['coefficients'][2] * potassium +
        data['coefficients'][3] * vitamin_K +
        data['coefficients'][4] * vitamin_B4 +
        data['coefficients'][5] * magnesium <= data['upper_bound'],
        f"cardiovascular_support_{resource}"
    )


# Add constraints based on energy stability index
energy_stability = {
    'r1': {'upper_bound': 601, 'coefficients': [10, 17, 19, 8, 21, 13]},
}

for resource, data in energy_stability.items():
    model.addConstr(
        data['coefficients'][0] * vitamin_D +
        data['coefficients'][1] * vitamin_B1 +
        data['coefficients'][2] * potassium +
        data['coefficients'][3] * vitamin_K +
        data['coefficients'][4] * vitamin_B4 +
        data['coefficients'][5] * magnesium <= data['upper_bound'],
        f"energy_stability_{resource}"
    )

# Add other constraints
model.addConstr(9 * vitamin_B1 + 2 * vitamin_B4 >= 28)
model.addConstr(9 * vitamin_B1 + 15 * vitamin_K >= 39)
model.addConstr(9 * vitamin_B1 + 7 * magnesium >= 22)
model.addConstr(22 * vitamin_D + 2 * vitamin_B4 >= 31)
model.addConstr(9 * vitamin_B1 + 15 * potassium >= 41)
model.addConstr(15 * vitamin_K + 2 * vitamin_B4 >= 37)
model.addConstr(15 * potassium + 15 * vitamin_K >= 34)
model.addConstr(15 * potassium + 7 * magnesium >= 38)
model.addConstr(22 * vitamin_D + 7 * magnesium >= 39)
model.addConstr(22 * vitamin_D + 15 * potassium >= 29)
model.addConstr(15 * vitamin_K + 7 * magnesium >= 27)
model.addConstr(22 * vitamin_D + 9 * vitamin_B1 >= 16)
model.addConstr(-10 * vitamin_D + 10 * vitamin_K >= 0)
model.addConstr(5 * vitamin_D - 7 * vitamin_B1 >= 0)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {model.status}")

