
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Define the variables
x0 = model.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_E")
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="grams_of_protein")
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_zinc")

# Objective function: minimize
model.setObjective(7.61*x0 + 3.07*x1 + 6.17*x2, GRB.MINIMIZE)

# Constraints
# Digestive support index constraints
model.addConstr(3*x0 + 14*x2 >= 24, name="digestive_support_vitamin_E_zinc")
model.addConstr(14*x1 + 14*x2 >= 30, name="digestive_support_protein_zinc")
model.addConstr(3*x0 + 14*x1 >= 17, name="digestive_support_vitamin_E_protein")
model.addConstr(3*x0 + 14*x1 + 14*x2 >= 17, name="total_digestive_support")

# Cardiovascular support index constraints
model.addConstr(5*x0 + 2*x2 >= 8, name="cardiovascular_support_vitamin_E_zinc")
model.addConstr(5*x0 + 12*x1 + 2*x2 >= 8, name="total_cardiovascular_support")
model.addConstr(5*x0 + 2*x2 <= 59, name="cardiovascular_support_upper_bound")

# Muscle growth index constraints
model.addConstr(7*x1 + 3*x2 >= 21, name="muscle_growth_protein_zinc")
model.addConstr(3*x0 + 7*x1 >= 13, name="muscle_growth_vitamin_E_protein")
model.addConstr(3*x0 + 7*x1 + 3*x2 >= 20, name="total_muscle_growth_lower_bound")
model.addConstr(3*x0 + 3*x2 <= 96, name="muscle_growth_upper_bound")

# Additional linear constraints
model.addConstr(5*x1 - 8*x2 >= 0, name="protein_zinc_constraint")
model.addConstr(8*x0 - x2 >= 0, name="vitamin_E_zinc_constraint")

# Solve the model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin E: {x0.x}")
    print(f"Grams of Protein: {x1.x}")
    print(f"Milligrams of Zinc: {x2.x}")
    print(f"Objective Value: {model.objVal}")
else:
    print("No optimal solution found.")
