
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="milligrams_of_vitamin_E", vtype=gp.GRB.INTEGER)  # integer
x1 = m.addVar(name="grams_of_protein")  # continuous
x2 = m.addVar(name="milligrams_of_zinc")  # continuous

# Define the objective function
m.setObjective(7.61 * x0 + 3.07 * x1 + 6.17 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * x0 + 14 * x1 + 14 * x2 <= 91, name="r0_constraint")
m.addConstr(5 * x0 + 12 * x1 + 2 * x2 <= 66, name="r1_constraint")
m.addConstr(3 * x0 + 7 * x1 + 3 * x2 <= 102, name="r2_constraint")

m.addConstr(3 * x0 + 14 * x2 >= 24, name="digestive_support_index_constraint_1")
m.addConstr(14 * x1 + 14 * x2 >= 30, name="digestive_support_index_constraint_2")
m.addConstr(3 * x0 + 14 * x1 >= 17, name="digestive_support_index_constraint_3")
m.addConstr(3 * x0 + 14 * x1 + 14 * x2 >= 17, name="digestive_support_index_constraint_4")

m.addConstr(5 * x0 + 2 * x2 >= 8, name="cardiovascular_support_index_constraint_1")
m.addConstr(5 * x0 + 12 * x1 + 2 * x2 >= 8, name="cardiovascular_support_index_constraint_2")

m.addConstr(7 * x1 + 3 * x2 >= 21, name="muscle_growth_index_constraint_1")
m.addConstr(3 * x0 + 7 * x1 >= 13, name="muscle_growth_index_constraint_2")
m.addConstr(3 * x0 + 7 * x1 + 3 * x2 >= 20, name="muscle_growth_index_constraint_3")

m.addConstr(5 * x1 - 8 * x2 >= 0, name="protein_zinc_constraint")
m.addConstr(8 * x0 - x2 >= 0, name="vitamin_E_zinc_constraint")

m.addConstr(5 * x0 + 2 * x2 <= 59, name="cardiovascular_support_index_constraint_3")
m.addConstr(3 * x0 + 3 * x2 <= 96, name="muscle_growth_index_constraint_4")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin E: {x0.varValue}")
    print(f"Grams of protein: {x1.varValue}")
    print(f"Milligrams of zinc: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
