
import gurobipy as gp

# Create a new model
m = gp.Model("carbohydrate_optimization")

# Create variables
peanutbutter_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")
cheeseburgers = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="cheeseburgers")
bagged_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")

# Set objective function
m.setObjective(7.59 * peanutbutter_sandwiches**2 + 1.23 * cheeseburgers**2 + 3.08 * bagged_salads**2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(21 * peanutbutter_sandwiches**2 + 22 * cheeseburgers**2 <= 204, "carb_constraint1")
m.addConstr(21 * peanutbutter_sandwiches**2 + 11 * bagged_salads**2 <= 312, "carb_constraint2")
m.addConstr(22 * cheeseburgers**2 + 11 * bagged_salads**2 <= 298, "carb_constraint3")
m.addConstr(21 * peanutbutter_sandwiches + 22 * cheeseburgers + 11 * bagged_salads <= 298, "carb_constraint4")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Peanutbutter Sandwiches: {peanutbutter_sandwiches.x}")
    print(f"Cheeseburgers: {cheeseburgers.x}")
    print(f"Bagged Salads: {bagged_salads.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

