
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables, considering the restrictions
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="peanutbutter_sandwiches")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="cheeseburgers")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="bagged_salads")

# Define the objective function
m.setObjective(7.59 * x0**2 + 1.23 * x1**2 + 3.08 * x2**2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(21*x0**2 + 22*x1**2 <= 204, name="carb_pbs_cb")
m.addConstr(21*x0**2 + 11*x2**2 <= 312, name="carb_pbs_bs")
m.addConstr(22*x1**2 + 11*x2**2 <= 298, name="carb_cb_bs")
m.addConstr(21*x0 + 22*x1 + 11*x2 <= 298, name="total_carb")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"peanutbutter_sandwiches: {x0.x}")
    print(f"cheeseburgers: {x1.x}")
    print(f"bagged_salads: {x2.x}")
else:
    print("No optimal solution found")
