
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    peanutbutter_sandwiches = model.addVar(lb=-float('inf'), ub=float('inf'), name="peanutbutter_sandwiches")
    cheeseburgers = model.addVar(lb=-float('inf'), ub=float('inf'), vtype=gurobi.GRB.INTEGER, name="cheeseburgers")
    bagged_salads = model.addVar(lb=-float('inf'), ub=float('inf'), name="bagged_salads")

    # Objective function
    model.setObjective(7.59 * peanutbutter_sandwiches**2 + 1.23 * cheeseburgers**2 + 3.08 * bagged_salads**2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(21**2 * peanutbutter_sandwiches**2 + 22**2 * cheeseburgers**2 <= 204, name="carbohydrates_constraint_1")
    model.addConstr(21**2 * peanutbutter_sandwiches**2 + 11**2 * bagged_salads**2 <= 312, name="carbohydrates_constraint_2")
    model.addConstr(22**2 * cheeseburgers**2 + 11**2 * bagged_salads**2 <= 298, name="carbohydrates_constraint_3")
    model.addConstr(21 * peanutbutter_sandwiches + 22 * cheeseburgers + 11 * bagged_salads <= 298, name="carbohydrates_constraint_4")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Peanutbutter sandwiches: {peanutbutter_sandwiches.varValue}")
        print(f"Cheeseburgers: {cheeseburgers.varValue}")
        print(f"Bagged salads: {bagged_salads.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
