
import gurobipy as gp

# Create a new model
model = gp.Model("optimize_work_hours")

# Create variables
peggy_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy_hours")
ringo_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ringo_hours")

# Set objective function
model.setObjective(7 * peggy_hours + 4 * ringo_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(1 * peggy_hours + 5 * ringo_hours >= 21, "total_likelihood_min")
model.addConstr(6 * peggy_hours + 7 * ringo_hours >= 48, "total_competence_min")
model.addConstr(3 * peggy_hours - 8 * ringo_hours >= 0, "custom_constraint")
model.addConstr(1 * peggy_hours + 5 * ringo_hours <= 44, "total_likelihood_max")
model.addConstr(6 * peggy_hours + 7 * ringo_hours <= 98, "total_competence_max")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Peggy's hours: {peggy_hours.x}")
    print(f"  Ringo's hours: {ringo_hours.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

