
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
peggy_hours = m.addVar(vtype=GRB.CONTINUOUS, name="Peggy_Hours")
ringo_hours = m.addVar(vtype=GRB.INTEGER, name="Ringo_Hours")

# Objective function: Maximize 7*peggy_hours + 4*ringo_hours
m.setObjective(7*peggy_hours + 4*ringo_hours, GRB.MAXIMIZE)

# Constraints
# Total combined likelihood to quit index is at least 21 and at most 44
m.addConstr(1*peggy_hours + 5*ringo_hours >= 21, "Likelihood_Lower_Bound")
m.addConstr(1*peggy_hours + 5*ringo_hours <= 44, "Likelihood_Upper_Bound")

# Total combined computer competence rating is at least 48 and at most 98
m.addConstr(6*peggy_hours + 7*ringo_hours >= 48, "Competence_Lower_Bound")
m.addConstr(6*peggy_hours + 7*ringo_hours <= 98, "Competence_Upper_Bound")

# Additional constraint: 3*peggy_hours - 8*ringo_hours >= 0
m.addConstr(3*peggy_hours - 8*ringo_hours >= 0, "Additional_Constraint")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Peggy Hours: {peggy_hours.X}")
    print(f"Ringo Hours: {ringo_hours.X}")
else:
    print("No optimal solution found")
