
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
hours_peggy = m.addVar(lb=0, name="hours_worked_by_Peggy")  # Can be fractional
hours_ringo = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours_worked_by_Ringo")  # Must be an integer

# Objective function: Maximize 7*hours_peggy + 4*hours_ringo
m.setObjective(7 * hours_peggy + 4 * hours_ringo, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(hours_peggy * 1 <= 55, "peggy_quit_index")
m.addConstr(hours_ringo * 5 <= 55, "ringo_quit_index")
m.addConstr(hours_peggy * 6 <= 103, "peggy_computer_rating")
m.addConstr(hours_ringo * 7 <= 103, "ringo_computer_rating")

m.addConstr(hours_peggy * 1 + hours_ringo * 5 >= 21, "combined_quit_index_min")
m.addConstr(hours_peggy * 1 + hours_ringo * 5 <= 44, "combined_quit_index_max")

m.addConstr(hours_peggy * 6 + hours_ringo * 7 >= 48, "combined_computer_rating_min")
m.addConstr(hours_peggy * 6 + hours_ringo * 7 <= 98, "combined_computer_rating_max")

m.addConstr(hours_peggy * 3 - hours_ringo * 8 >= 0, "linear_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Peggy: {hours_peggy.varValue}")
    print(f"Hours worked by Ringo: {hours_ringo.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("The model is infeasible.")
