
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
eggs = m.addVar(vtype=gp.GRB.INTEGER, name="eggs")
steaks = m.addVar(vtype=gp.GRB.CONTINUOUS, name="steaks")
apple_pies = m.addVar(vtype=gp.GRB.INTEGER, name="apple_pies")
kiwis = m.addVar(vtype=gp.GRB.CONTINUOUS, name="kiwis")

# Set objective function
m.setObjective(5.3 * eggs + 7.7 * steaks + 7.28 * apple_pies + 6.33 * kiwis, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.48 * eggs + 0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis <= 183, "iron_upper_bound")
m.addConstr(0.48 * eggs + 2.17 * kiwis >= 33, "iron_eggs_kiwis")
m.addConstr(0.44 * steaks + 2.17 * kiwis >= 28, "iron_steaks_kiwis")
m.addConstr(2.47 * apple_pies + 2.17 * kiwis >= 31, "iron_apple_pies_kiwis")
m.addConstr(0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis >= 33, "iron_steaks_apple_pies_kiwis")
m.addConstr(0.48 * eggs + 0.44 * steaks + 2.17 * kiwis >= 33, "iron_eggs_steaks_kiwis")
m.addConstr(0.48 * eggs + 2.47 * apple_pies + 2.17 * kiwis >= 33, "iron_eggs_apple_pies_kiwis")
m.addConstr(0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis >= 30, "iron_steaks_apple_pies_kiwis2")
m.addConstr(0.48 * eggs + 0.44 * steaks + 2.17 * kiwis >= 30, "iron_eggs_steaks_kiwis2")
m.addConstr(0.48 * eggs + 2.47 * apple_pies + 2.17 * kiwis >= 30, "iron_eggs_apple_pies_kiwis2")
m.addConstr(0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis >= 35, "iron_steaks_apple_pies_kiwis3")
m.addConstr(0.48 * eggs + 0.44 * steaks + 2.17 * kiwis >= 35, "iron_eggs_steaks_kiwis3")
m.addConstr(0.48 * eggs + 2.47 * apple_pies + 2.17 * kiwis >= 35, "iron_eggs_apple_pies_kiwis3")
m.addConstr(0.48 * eggs + 0.44 * steaks <= 148, "iron_eggs_steaks_upper")
m.addConstr(0.44 * steaks + 2.47 * apple_pies <= 61, "iron_steaks_apple_pies_upper")
m.addConstr(0.44 * steaks + 2.17 * kiwis <= 95, "iron_steaks_kiwis_upper")
m.addConstr(0.48 * eggs + 2.17 * kiwis <= 110, "iron_eggs_kiwis_upper")
m.addConstr(2.47 * apple_pies + 2.17 * kiwis <= 144, "iron_apple_pies_kiwis_upper")
m.addConstr(0.48 * eggs + 0.44 * steaks + 2.17 * kiwis <= 160, "iron_eggs_steaks_kiwis_upper")
m.addConstr(0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis <= 126, "iron_steaks_apple_pies_kiwis_upper")
m.addConstr(0.48 * eggs + 0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis <= 126, "iron_all_upper")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

