
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    eggs = model.addVar(vtype=gurobi.GRB.INTEGER, name="eggs", lb=0)
    steaks = model.addVar(vtype=gurobi.GRB.CONTINUOUS, name="steaks", lb=0)
    apple_pies = model.addVar(vtype=gurobi.GRB.INTEGER, name="apple_pies", lb=0)
    kiwis = model.addVar(vtype=gurobi.GRB.INTEGER, name="kiwis", lb=0)

    # Objective function
    model.setObjective(5.3 * eggs + 7.7 * steaks + 7.28 * apple_pies + 6.33 * kiwis, gurobi.GRB.MAXIMIZE)

    # Iron content per item
    iron_eggs = 0.48
    iron_steaks = 0.44
    iron_apple_pies = 2.47
    iron_kiwis = 2.17

    # Constraints
    # At least 33 mg from eggs and kiwis
    model.addConstraint(iron_eggs * eggs + iron_kiwis * kiwis >= 33, name="eggs_kiwis_iron")
    # At least 28 mg from steaks and kiwis
    model.addConstraint(iron_steaks * steaks + iron_kiwis * kiwis >= 28, name="steaks_kiwis_iron")
    # At least 31 mg from apple pies and kiwis
    model.addConstraint(iron_apple_pies * apple_pies + iron_kiwis * kiwis >= 31, name="apple_pies_kiwis_iron")
    # At least 33 mg from steaks, apple pies, and kiwis
    model.addConstraint(iron_steaks * steaks + iron_apple_pies * apple_pies + iron_kiwis * kiwis >= 33, name="steaks_apple_pies_kiwis_iron")
    # At least 33 mg from eggs, steaks, and kiwis
    model.addConstraint(iron_eggs * eggs + iron_steaks * steaks + iron_kiwis * kiwis >= 33, name="eggs_steaks_kiwis_iron")
    # At least 33 mg from eggs, apple pies, and kiwis
    model.addConstraint(iron_eggs * eggs + iron_apple_pies * apple_pies + iron_kiwis * kiwis >= 33, name="eggs_apple_pies_kiwis_iron")
    # At least 30 mg from steaks, apple pies, and kiwis
    model.addConstraint(iron_steaks * steaks + iron_apple_pies * apple_pies + iron_kiwis * kiwis >= 30, name="steaks_apple_pies_kiwis_iron_2")
    # At least 30 mg from eggs, steaks, and kiwis
    model.addConstraint(iron_eggs * eggs + iron_steaks * steaks + iron_kiwis * kiwis >= 30, name="eggs_steaks_kiwis_iron_2")
    # At least 30 mg from eggs, apple pies, and kiwis
    model.addConstraint(iron_eggs * eggs + iron_apple_pies * apple_pies + iron_kiwis * kiwis >= 30, name="eggs_apple_pies_kiwis_iron_2")
    # At least 35 mg from steaks, apple pies, and kiwis
    model.addConstraint(iron_steaks * steaks + iron_apple_pies * apple_pies + iron_kiwis * kiwis >= 35, name="steaks_apple_pies_kiwis_iron_3")
    # At least 35 mg from eggs, steaks, and kiwis
    model.addConstraint(iron_eggs * eggs + iron_steaks * steaks + iron_kiwis * kiwis >= 35, name="eggs_steaks_kiwis_iron_3")
    # At least 35 mg from eggs, apple pies, and kiwis
    model.addConstraint(iron_eggs * eggs + iron_apple_pies * apple_pies + iron_kiwis * kiwis >= 35, name="eggs_apple_pies_kiwis_iron_3")

    # Upper bounds
    # At most 148 mg from eggs and steaks
    model.addConstraint(iron_eggs * eggs + iron_steaks * steaks <= 148, name="eggs_steaks_iron_ub")
    # At most 61 mg from steaks and apple pies
    model.addConstraint(iron_steaks * steaks + iron_apple_pies * apple_pies <= 61, name="steaks_apple_pies_iron_ub")
    # At most 95 mg from steaks and kiwis
    model.addConstraint(iron_steaks * steaks + iron_kiwis * kiwis <= 95, name="steaks_kiwis_iron_ub")
    # At most 110 mg from eggs and kiwis
    model.addConstraint(iron_eggs * eggs + iron_kiwis * kiwis <= 110, name="eggs_kiwis_iron_ub")
    # At most 144 mg from apple pies and kiwis
    model.addConstraint(iron_apple_pies * apple_pies + iron_kiwis * kiwis <= 144, name="apple_pies_kiwis_iron_ub")
    # At most 160 mg from eggs, steaks, and kiwis
    model.addConstraint(iron_eggs * eggs + iron_steaks * steaks + iron_kiwis * kiwis <= 160, name="eggs_steaks_kiwis_iron_ub_2")
    # At most 126 mg from steaks, apple pies, and kiwis
    model.addConstraint(iron_steaks * steaks + iron_apple_pies * apple_pies + iron_kiwis * kiwis <= 126, name="steaks_apple_pies_kiwis_iron_ub_2")
    # At most 126 mg from all items
    model.addConstraint(iron_eggs * eggs + iron_steaks * steaks + iron_apple_pies * apple_pies + iron_kiwis * kiwis <= 126, name="all_items_iron_ub")

    # At most 183 mg of iron in total
    model.addConstraint(iron_eggs * eggs + iron_steaks * steaks + iron_apple_pies * apple_pies + iron_kiwis * kiwis <= 183, name="total_iron_ub")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Eggs: ", eggs.varValue)
        print("Steaks: ", steaks.varValue)
        print("Apple Pies: ", apple_pies.varValue)
        print("Kiwis: ", kiwis.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
