
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
pickles = m.addVar(lb=0, name="pickles")
hot_dogs = m.addVar(lb=0, name="hot_dogs")
kale_salads = m.addVar(lb=0, name="kale_salads")

# Set objective function
m.setObjective(7 * pickles + 2 * hot_dogs + 3 * kale_salads, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * hot_dogs + 17 * kale_salads >= 30, "health_constr1")
m.addConstr(25 * pickles + 17 * kale_salads >= 18, "health_constr2")
m.addConstr(25 * pickles + 14 * hot_dogs >= 18, "health_constr3")
m.addConstr(25 * pickles + 14 * hot_dogs + 17 * kale_salads >= 34, "health_constr4")
m.addConstr(25 * pickles + 14 * hot_dogs + 17 * kale_salads >= 34, "health_constr5") # Redundant constraint

m.addConstr(7 * hot_dogs + 14 * kale_salads >= 49, "protein_constr1")
m.addConstr(16 * pickles + 7 * hot_dogs >= 90, "protein_constr2")
m.addConstr(16 * pickles + 7 * hot_dogs + 14 * kale_salads >= 90, "protein_constr3")

m.addConstr(-1 * hot_dogs + 8 * kale_salads >= 0, "constr4")
m.addConstr(25 * pickles + 14 * hot_dogs <= 67, "health_constr6")
m.addConstr(16 * pickles + 7 * hot_dogs + 14 * kale_salads <= 263, "protein_constr4")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('pickles:', pickles.x)
    print('hot_dogs:', hot_dogs.x)
    print('kale_salads:', kale_salads.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

