
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
pickles = m.addVar(lb=0, name="pickles")  # Non-integer amount allowed
hot_dogs = m.addVar(lb=0, name="hot_dogs")  # Non-integer amount allowed
kale_salads = m.addVar(lb=0, name="kale_salads")  # Non-integer amount allowed

# Objective function: Minimize 7*pickles + 2*hot_dogs + 3*kale_salads
m.setObjective(7 * pickles + 2 * hot_dogs + 3 * kale_salads, gp.GRB.MINIMIZE)

# Constraints
# 1. Total healthiness rating from hot dogs and kale salads >= 30
m.addConstr(14 * hot_dogs + 17 * kale_salads >= 30, name="health_hot_dogs_kale")

# 2. Total healthiness rating from pickles and kale salads >= 18
m.addConstr(25 * pickles + 17 * kale_salads >= 18, name="health_pickles_kale")

# 3. Total healthiness rating from pickles and hot dogs >= 18
m.addConstr(25 * pickles + 14 * hot_dogs >= 18, name="health_pickles_hot_dogs")

# 4. Total healthiness rating from pickles, hot dogs, and kale salads >= 34
m.addConstr(25 * pickles + 14 * hot_dogs + 17 * kale_salads >= 34, name="health_all")

# 5. Total grams of protein from hot dogs and kale salads >= 49
m.addConstr(7 * hot_dogs + 14 * kale_salads >= 49, name="protein_hot_dogs_kale")

# 6. Total grams of protein from pickles and hot dogs >= 90
m.addConstr(16 * pickles + 7 * hot_dogs >= 90, name="protein_pickles_hot_dogs")

# 7. Total grams of protein from pickles, hot dogs, and kale salads >= 90
m.addConstr(16 * pickles + 7 * hot_dogs + 14 * kale_salads >= 90, name="protein_all")

# 8. -1 * hot dogs + 8 * kale salads >= 0
m.addConstr(-1 * hot_dogs + 8 * kale_salads >= 0, name="hot_dogs_kale_ratio")

# 9. Total healthiness rating from pickles and hot dogs <= 67
m.addConstr(25 * pickles + 14 * hot_dogs <= 67, name="health_pickles_hot_dogs_max")

# 10. Total grams of protein from pickles, hot dogs, and kale salads <= 263
m.addConstr(16 * pickles + 7 * hot_dogs + 14 * kale_salads <= 263, name="protein_all_max")

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Pickles: {pickles.varValue}")
    print(f"Hot Dogs: {hot_dogs.varValue}")
    print(f"Kale Salads: {kale_salads.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
