
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams of potassium")
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams of vitamin B5")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams of vitamin D")
x3 = m.addVar(lb=0, vtype=GRB.INTEGER, name="grams of fat")
x4 = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams of vitamin B4")
x5 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams of vitamin B6")
x6 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams of vitamin C")

# Set objective function
m.setObjective(9.02*x0*x1 + 7.33*x0*x6 + 8.99*x1*x1 + 4.74*x1*x3 + 7.05*x1*x4 + 2.25*x2*x2 + 9.87*x2*x5 + 1.54*x3*x4 + 1.78*x4*x4 + 6.76*x4*x5 + 7.64*x5*x6 + 8.87*x1 + 8.4*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x0 + 6*x1 + 10*x2 + 9*x3 + 1*x4 + 11*x5 + 10*x6 <= 361, "r0")
m.addConstr(11*x0 + 7*x1 + 6*x2 + 5*x3 + 3*x4 + 7*x5 + 2*x6 <= 178, "r1")

m.addConstr(11*x5*x5 + 10*x6*x6 >= 26)
m.addConstr(6*x1 + 1*x4 >= 38)
m.addConstr(6*x1*x1 + 9*x3*x3 >= 51)
m.addConstr(10*x2*x2 + 1*x4*x4 >= 26)
m.addConstr(3*x0 + 1*x4 >= 46)
m.addConstr(3*x0 + 11*x5 >= 20)
m.addConstr(6*x1*x1 + 10*x2*x2 >= 38)
m.addConstr(10*x2 + 9*x3 >= 38)
m.addConstr(9*x3 + 11*x5 >= 28)
m.addConstr(10*x2 + 11*x5 >= 51)
m.addConstr(1*x4 + 10*x6 >= 42)
m.addConstr(3*x0 + 10*x6 >= 44)
m.addConstr(3*x0 + 6*x1 + 1*x4 >= 44)
m.addConstr(3*x0 + 9*x3 + 1*x4 >= 44)
m.addConstr(6*x1 + 9*x3 + 1*x4 >= 44)
m.addConstr(3*x0 + 9*x3 + 11*x5 >= 44)
m.addConstr(10*x2*x2 + 9*x3*x3 + 11*x5*x5 >= 44)
m.addConstr(3*x0 + 1*x4 + 10*x6 >= 44)
m.addConstr(3*x0 + 10*x2 + 10*x6 >= 44)
m.addConstr(6*x1 + 10*x2 + 1*x4 >= 44)
m.addConstr(3*x0 + 6*x1 + 10*x6 >= 44)
m.addConstr(10*x2 + 9*x3 + 1*x4 >= 44)
m.addConstr(6*x1 + 11*x5 + 10*x6 >= 44)
m.addConstr(3*x0*x0 + 10*x2*x2 + 11*x5*x5 >= 44)


# ... (Rest of the constraints)


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

