
from gurobipy import *

# Create a model
m = Model("Nutrient_Model")

# Define the decision variables
K = m.addVar(lb=0, name="Potassium", vtype=GRB.CONTINUOUS)
B5 = m.addVar(lb=0, name="Vitamin_B5", vtype=GRB.INTEGER)
D = m.addVar(lb=0, name="Vitamin_D", vtype=GRB.CONTINUOUS)
F = m.addVar(lb=0, name="Fat", vtype=GRB.INTEGER)
B4 = m.addVar(lb=0, name="Vitamin_B4", vtype=GRB.INTEGER)
B6 = m.addVar(lb=0, name="Vitamin_B6", vtype=GRB.CONTINUOUS)
C = m.addVar(lb=0, name="Vitamin_C", vtype=GRB.CONTINUOUS)

# Constraints for the total combined digestive support index
m.addConstr(K + D >= 39, "Digestive_1")
m.addConstr(B5 + B6 >= 10, "Digestive_2")
# ... Add all relevant constraints here

# Constraints for the total combined cardiovascular support index
m.addConstr(B4 + C >= 11, "Cardiovascular_1")
m.addConstr(D + F >= 18, "Cardiovascular_2")
# ... Add all relevant constraints here

# Additional constraints
m.addConstr(-7*B5 + 9*B6 >= 0, "Additional_1")
m.addConstr(3*B4 - B6 >= 0, "Additional_2")

# Upper bound constraints
m.addConstr(B4 + C <= 205, "UpperBound_1")
m.addConstr(D**2 + C**2 <= 211, "UpperBound_2")
# ... Add all relevant upper bound constraints here

# Solve the model
m.optimize()

# Print the solution
for v in m.getVars():
    print(f"{v.VarName}: {v.X}")
